const sliders = async function () {
    const HomeCarouselElement = document.querySelector('.home-carousel .swiper-container') !== null;
    const SwiperProductElem = document.querySelector('.swiper-feature-products .swiper-container') !== null;

    if (HomeCarouselElement || SwiperProductElem) {
        let SwiperLib = await import('swiper/bundle');
        let Swiper = SwiperLib.default;

        if (HomeCarouselElement) {
            const homepageSwiper = new Swiper('.home-carousel .swiper-container', {
                // loop: true,
                preloadImages: false,
                lazy: true,
                effect: "fade",
                fadeEffect: {
                    crossFade: true
                },
                autoplay: {
                    delay: 5000,
                },
                speed: 1500,
                slidersPerView: 1,
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true
                },
            });
        }

        if (SwiperProductElem) {
            const swiperFeatured = new Swiper('.swiper-feature-products .swiper-container', {
                slidesPerView: 1,
                slidesPerGroup: 1,
                spaceBetween: 10,
                breakpoints: {
                    768: {
                        slidesPerGroup: 2,
                        slidesPerView: 2,
                        spaceBetween: 18
                    }
                },
                navigation: {
                    nextEl: ".swiper-button-next",
                    prevEl: ".swiper-button-prev",
                },
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true
                },
            });
        }
    }
}

exports.init = sliders;