module.exports = function () {
    const header = document.querySelector('.main-header');

    /**
     * Top link
     */
    const mainMenu = document.querySelector('.main-menu'),
        menuLinks = document.querySelectorAll('.main-header__nav .main-header__nav__link'),
        menuContainer = document.querySelectorAll('.main-menu .main-menu__container');

    /**
     * Lazy Image Loading Mechanism
     */
    let imagesLoaded = false;
    const lazyLoadedImages = document.querySelectorAll('.main-menu .main-menu__lazy-img');
    const productIcons = document.querySelectorAll('.main-menu .btn-product__icon');

    const lazyLoadMenuImages = () => {
        if (!imagesLoaded) {
            imagesLoaded = true;

            productIcons.forEach((icon) => {
                icon.setAttribute("style", icon.getAttribute("data-style"));
            })

            lazyLoadedImages.forEach((item) => {
                const imgTag = item.querySelector('img'),
                    imgHref = imgTag.getAttribute("data-src"),
                    sources = item.querySelectorAll('source');

                imgTag.setAttribute("src", imgHref);
                if (sources.length) {
                    sources.forEach((source) => {
                        source.setAttribute("srcset", source.getAttribute("data-srcset"));
                    })
                }
            });


        }
    }

    document.addEventListener('scroll', function (e) {
        if (window.innerWidth >= 1200) {
            menuLinks.forEach((link, index) => {
                link.classList.remove('is-active');
            });
            mainMenu.classList.remove('is-slide');
            header.classList.remove('menu-active');
        }
    });

    // window.onload=function() {
    //     mainMenu.style.display = 'block';
    // }

    menuLinks.forEach((link, index) => {
        link.addEventListener('click', (e) => {
            e.preventDefault();
            lazyLoadMenuImages();

            if (!link.classList.contains('is-active')) {
                menuLinks.forEach((linkItem) => {
                    linkItem.classList.remove('is-active');
                });

                menuContainer.forEach((container) => {
                    container.classList.remove('is-active');
                });

                link.classList.add('is-active');
                menuContainer[index].classList.add('is-active');
                mainMenu.classList.add('is-slide');
                header.classList.add('menu-active');
            } else {
                link.classList.remove('is-active');
                mainMenu.classList.remove('is-slide');
                header.classList.remove('menu-active');
            }

            // mainMenu.classList.add('is-slide');
            // link.classList.add('is-active');
            // header.classList.add('menu-active');

            // if ( menuContainer[index] ) {
            //     e.preventDefault();
            //     if ( link.classList.contains('is-active') ) {
            //         mainMenu.classList.remove('is-slide');
            //         link.classList.remove('is-active');
            //         header.classList.remove('menu-active');
            //     } else {
            //         menuLinks.forEach( (link) => {
            //             link.classList.remove('is-active');
            //         });
            //
            //         menuContainer.forEach( (container) => {
            //             container.classList.remove('is-active');
            //         });
            //
            //         menuContainer[index].classList.add('is-active');
            //
            //         mainMenu.classList.add('is-slide');
            //         link.classList.add('is-active');
            //         header.classList.add('menu-active');
            //     }
            // } else {
            //
            // }
        }, false);
    });

    const menuLinksMobile = document.querySelectorAll('.main-menu__nav__link'),
        menuButton = document.querySelector('.main-header__btn'),
        menuMobileBack = document.querySelectorAll('.main-menu__container-title');

    menuButton.addEventListener('click', () => {
        if (menuButton.classList.contains('is-active')) {
            menuButton.classList.remove('is-active');
            mainMenu.classList.remove('is-slide');
            header.classList.remove('menu-active');
        } else {
            menuButton.classList.add('is-active');
            mainMenu.classList.add('is-slide');
            header.classList.add('menu-active');
        }
    });

    menuLinksMobile.forEach((link, index) => {
        link.addEventListener('click', (e) => {

            if (menuContainer[index]) {
                e.preventDefault();
                if (link.classList.contains('is-active')) {
                    mainMenu.classList.remove('is-slide');
                    link.classList.remove('is-active');
                    header.classList.remove('menu-active');
                } else {
                    menuLinks.forEach((link) => {
                        link.classList.remove('is-active');
                    });

                    menuContainer.forEach((container) => {
                        container.classList.remove('is-active');
                    });

                    menuContainer[index].classList.add('is-active');

                    mainMenu.classList.add('is-slide');
                    link.classList.add('is-active');
                    header.classList.add('menu-active');
                }
            } else {

            }
        }, false);
    });

    menuMobileBack.forEach((link, index) => {
        link.addEventListener('click', (e) => {
            e.preventDefault();
            menuContainer.forEach((container) => {
                container.classList.remove('is-active');
            });
            menuLinksMobile.forEach((item) => {
                item.classList.remove('is-active');
            });
        }, false);
    });


    /**
     * Sectors link hover
     */
    const sectors = document.querySelectorAll('.main-menu__container--solutions .main-menu__link'),
        sectorBox = document.querySelectorAll('.main-menu__container--solutions .main-menu__sector');

    let activeSector = false;

    if (window.innerWidth >= 1200) {
        sectors.forEach((item, index) => {
            if (item.classList.contains('is-active')) {
                activeSector = index;
            }

            item.addEventListener('mouseenter', () => {
                sectors.forEach((sector) => {
                    sector.classList.remove('is-active');
                });
                (activeSector) ? sectorBox[activeSector].classList.remove('is-active'): null;
                sectorBox[index].classList.add('is-active');
            });
            item.addEventListener('mouseleave', () => {
                (activeSector) ? sectorBox[activeSector].classList.add('is-active'): null;
                sectorBox[index].classList.remove('is-active');
            });
        })
    }

    /**
     * Products link hover
     */
    const productsTab = document.querySelectorAll('.main-menu__tabs .main-menu__tabs__tab'),
        productsContent = document.querySelectorAll('.main-menu__tabs .main-menu__tabs__content')

    productsTab.forEach((tab, index) => {

        tab.addEventListener('click', (e) => {
            productsTab.forEach((item) => {
                item.classList.remove('is-active');
            });

            productsContent.forEach((content) => {
                content.classList.remove('is-active');
            });

            productsContent[index].classList.add('is-active');
            tab.classList.add('is-active');
        });
    })
}