import "../scss/main.scss";

import {
    idempotentBabelPolyfill
} from 'idempotent-babel-polyfill';
idempotentBabelPolyfill();

// Vue
import Vue from 'vue';
import axios from "axios";
import VueAxios from "vue-axios";
import {
    VueMasonryPlugin
} from 'vue-masonry';

Vue.use(VueAxios, axios);
Vue.use(VueMasonryPlugin)

import VueMq from 'vue-mq'

Vue.use(VueMq, {
    breakpoints: { // default breakpoints - customize this
        sm: 768,
        md: 1024,
        lg: Infinity,
    },
    defaultBreakpoint: 'sm' // customize this for SSR
})

// LazyLoad - https://github.com/aFarkas/lazysizes
import 'lazysizes';
// import a plugin
import 'lazysizes/plugins/parent-fit/ls.parent-fit';

var fMainMenu = require('./main-menu_ref.js');
var fHeader = require('./header.js');
var fHomeBanner = require('./home-banner.js');
var fPopupVideo = require('./popup-video.js');
var fMap = require('./map.js');
var fSliders = require('./sliders.js');
var fAccordions = require('./accordion');

// External Scripts Load
var isChat = false;
var isGA = false;
var fMountChat = require('./chat.js');
var fMountGA = require('./googleAnalitics.js');

function refreshScripts() {
    fSliders.init();
    fAccordions();
    fMainMenu();
    fHeader();
    fHomeBanner();
    fPopupVideo();
    fMap.init();

    window.addEventListener('resize', () => {
        // fMap();
        fHeader();
        // fMainMenu();
    }, true);
}

// Load some external scripts after user's first sroll
$(document).on('scroll', function () {
    if (!isChat) {
        isChat = true;
        fMountChat();
    }
});

$(document).ready(function () {
    refreshScripts();

    $(".post__share__btn").on("click", function () {
        $('.post__share__wrapper').slideToggle();
    })
});

window.onload = function () {
    if (!isGA) {
        isGA = true;
        fMountGA();
    }
};

Vue.component(
    'home-slider-img',
    () => import('./vue/home-slider-img.vue')
);

Vue.component(
    'knowledge-centre-list',
    () => import('./vue/knowledge-centre-list.vue')
);

Vue.component(
    'products',
    () => import('./vue/products.vue')
);

Vue.component(
    'product-variants',
    () => import('./vue/partials/product-variants-dropdown.vue')
);

Vue.component(
    'related-products',
    () => import('./vue/related-products.vue')
);

Vue.component(
    'product-search',
    () => import('./vue/product-search.vue')
);

if (!document.body.classList.contains('page-template-tpl_contact')) {
    const app = new Vue({
        el: '#main'
    });
}