module.exports = function () {
    const allPanels = $('.products__filter__group .products__filter__group__container');

    $('.products__filter__group.is-active .products__filter__group__container').slideDown();

    $('.products__filter__group .products__filter__group__btn').click(function (e) {
        e.preventDefault();
        if ($(this).parent().hasClass('is-active')) {
            allPanels.slideUp('slow');
            allPanels.parent().removeClass('is-active');
        } else {
            allPanels.slideUp('slow');
            allPanels.parent().removeClass('is-active');
            $(this).parent().addClass('is-active');
            $(this).next().slideDown('slow');
        }
        return false;
    });

    /**
     * Product
     */
    const productsAllPanels = $('.product__content__accordion__copy');

    $('.product__content__accordion__copy.is-active').slideDown('slow');

    $('.product__content__accordion__title').click(function (e) {
        e.preventDefault();
        if ($(this).hasClass('is-active')) {
            productsAllPanels.slideUp('slow');
            $(this).removeClass('is-active');
        } else {
            productsAllPanels.prev().removeClass('is-active');
            productsAllPanels.slideUp('slow');
            $(this).addClass('is-active');
            $(this).next().slideDown('slow');
        }
        return false;
    });

    /**
     * Home
     */
    const homAllPanels = $('.home-accordion__content__text'),
        homeImages = $('.home-accordion__images').children();

    $('.home-accordion__content.is-active .home-accordion__content__text').slideDown();

    $('.home-accordion__content__title').click(function (e) {
        e.preventDefault();
        let index = $(this).attr('data-index');

        // Images left
        homeImages.removeClass('is-active');
        homeImages.eq(index).addClass('is-active');

        // Content right
        homAllPanels.slideUp('slow');
        homAllPanels.parent().removeClass('is-active');
        $(this).parent().addClass('is-active');
        $(this).next().slideDown('slow');
        return false;
    });
}