<?php
    $heading = get_sub_field('heading');
?>
<section class="vacancies-list">
    <div class="vacancies-list__container container">
        <div class="vacancies-list__heading">
            <h2><?php echo $heading; ?></h2>
        </div>
        <div class="vacancies-list__table">
            <div class="vacancies-list__table__wrapper">
                <?php
                // Custom WP query query_vacancies
                $args_query_vacancies = array(
                    'post_type' => array('vacancies'),
                    'posts_per_page' => -1,
                    'order' => 'DESC',
                );

                $query_vacancies = new WP_Query( $args_query_vacancies );

                if ( $query_vacancies->have_posts() ) :
                    ?>
                    <table border="0">
                        <thead>
                        <tr>
                            <th>Position</th>
                            <th>Location</th>
                            <th>Status</th>
                            <th>Salary</th>
                            <th>Working Hours</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php while ( $query_vacancies->have_posts() ) : $query_vacancies->the_post(); ?>
                            <?php
                            // Check value exists.
                            if( have_rows('aside') ):

                                // Loop through rows.
                                while ( have_rows('aside') ) : the_row();

                                    // Case: Info.
                                    if( get_row_layout() == 'information' ):
                                        get_template_part('sections/vacancies/info');
                                    endif;
                                    // End loop.
                                endwhile;

                            // No value.
                            else :
                                // Do something...
                            endif;
                            ?>
                        <?php endwhile;?>
                        </tbody>
                    </table>
                <?php endif; wp_reset_postdata(); ?>
            </div>
        </div>
    </div>
</section>