<section class="sectors">
    <div class="sectors__container container">
        <div class="sectors__wrapper row">

            <?php
                // Custom WP query querysector
                $args_querysector = array(
                    'post_type' => array('sector'),
                    'posts_per_page' => -1,
                    'order' => 'DESC',
                );

                $querysector = new WP_Query( $args_querysector );

                if ( $querysector->have_posts() ) : ?>
                <?php while ( $querysector->have_posts() ) : $querysector->the_post(); ?>
                    <?php
                        $box = get_field('box');
                        $bg = $box['background'];
                        $title = $box['title'];
                        $content = $box['content'];
                    ?>
                    <div class="sectors__item col">
                        <a class="sectors__item__wrapper"
                           href="<?php the_permalink(); ?>"
                           title="<?php the_title(); ?>"
                        >
                            <?php
                                $imageVar = $bg;
                                $imageClass = 'sectors__item__bg';
                                include( locate_template( 'partials/image-srcset.php', false, false ) );
                            ?>
                            <p class="sectors__item__title">
                                <?php echo $box['title']; ?>
                                <?php if ( $box['content'] ) : ?>
                                    <span class="sectors__item__content"><?php echo $box['content']; ?></span>
                                <?php endif; ?>
                            </p>

                            <p class="sectors__item__btn btn btn--more">Learn more</p>
                        </a>
                    </div>
                <?php endwhile; ?>
            <?php endif; wp_reset_postdata(); ?>
        </div>
    </div>
</section>