<?php
    $sectorID = $post->ID;

    $request = new WP_REST_Request( 'POST', '/post/products-sector' );
    $request->set_query_params( [ 'sector' => $sectorID ] );
    $response = rest_do_request( $request );
    $server = rest_get_server();
    $data = $server->response_to_data( $response, false )['products'];
?>

<?php
    // Custom WP query query_related_products
    $args_query_related_products = array(
        'post_type' => array('product'),
        'posts_per_page' => -1,
        'order' => 'DESC',
//        'orderby' => 'rand',
        'meta_query' => array(
            array(
                'key' => 'sectors',
                'value' => $sectorID,
                'compare' => 'LIKE'
            )
        )
    );

    $query_related_products = new WP_Query( $args_query_related_products );

    if ( $query_related_products->have_posts() ) :
?>
    <!--
<section class="related-products bg-silver">
    <div class="related-products__container container">
        <div class="heading-border">
            <h2>Related product</h2>
        </div>
        <div class="related-products__wrapper row">
            <?php while ( $query_related_products->have_posts() ) : $query_related_products->the_post(); ?>
                <div class="related-products__item col">
                    <?php get_template_part('partials/product'); ?>
                </div>
            <?php endwhile; ?>
        </div>
    </div>
</section>
-->
<?php endif; wp_reset_postdata(); ?>
<section class="related-products bg-silver">
    <div class="related-products__container container">
        <div class="heading-border">
            <h2>Related product</h2>
        </div>
        <div class="loading bg-silver">
            <svg width="42.613" height="46.167" viewBox="0 0 32.613 36.167">
                <g id="Group_412" data-name="Group 412" transform="translate(-96 -580.917)">
                    <path id="Path_2048" data-name="Path 2048" d="M42.267,27.307a3.318,3.318,0,0,0-1.66.445L29.12,34.383a3.321,3.321,0,0,0-1.66,2.876V50.521A3.321,3.321,0,0,0,29.12,53.4l11.486,6.631a3.322,3.322,0,0,0,3.321,0L55.412,53.4a3.321,3.321,0,0,0,1.661-2.876V37.259a3.321,3.321,0,0,0-1.661-2.876L43.927,27.752a3.319,3.319,0,0,0-1.66-.445Z" transform="translate(70.04 555.11)" fill="none" stroke="#494949" stroke-width="3"/>
                    <g id="Group_347" data-name="Group 347" transform="translate(-657.138 -1934.001)">
                        <circle id="Ellipse_432" data-name="Ellipse 432" cx="1" cy="1" r="1" transform="translate(762.991 2532.198)" fill="#494949"/>
                        <circle id="Ellipse_433" data-name="Ellipse 433" cx="1" cy="1" r="1" transform="translate(767.991 2532.198)" fill="#494949"/>
                        <circle id="Ellipse_434" data-name="Ellipse 434" cx="1" cy="1" r="1" transform="translate(772.991 2532.198)" fill="#494949"/>
                    </g>
                </g>
            </svg>
        </div>
        <related-products sectorid='<?php echo $sectorID; ?>'>
            <?php if($data) : ?>
                <div style="display:none;">
                    <div class="related-products__wrapper row">
                        <?php foreach($data as $item) : ?>
                            <div class="products__list__item col">
                                <a href="<?= $item['url']; ?>" title="View" class="box-product__wrapper">
                                    <div class="box-product__image">
                                        <?php
                                            $imageVar = $item['box']['image'];
                                            $imageClass = '';
                                            include( locate_template( 'partials/image-srcset.php', false, false ) );
                                        ?>
                                    </div>
                                    <h4 class="box-product__title">
                                        <span><?= $item['title']; ?></span>
                                        <?php if($item['title'] && $item['title'] != '') : ?>
                                            <span>/ <?= $item['box']['code']; ?></span>
                                        <?php endif; ?>
                                    </h4>
                                    <div class="box-product__excerpt"><?= $item['box']['excerpt']; ?></div>
                                    <div class="box-product__sizes">
                                        <?php if($item['box']['sizes']) : ?>
                                            <strong>Dimensions:</strong><br>
                                            <?= $item['box']['sizes']; ?>
                                        <?php endif; ?>
                                    </div>
                                    <div class="box-product__btn btn btn--view">View</div>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        </related-products>
    </div>
</section>
