<?php 
$request = new WP_REST_Request( 'GET', '/get/knowledge-centre' );
$response = rest_do_request( $request );
$server = rest_get_server();
$data = $server->response_to_data( $response, false )["posts"];



$related_posts_by_sector = array();

foreach($data as $item) {
    if($item['sectors']) {
        foreach ( $item['sectors'] as $sector) {
            if ($post->ID == $sector->ID) {
                $related_posts_by_sector[] = $item;
            }
        }   
    }
}

$related_posts_by_sector = array_unique($related_posts_by_sector); 
?>
<section class="related-posts bg-silver">
    <div class="related-posts__container container">
        <knowledge-centre-list :sector_id="<?php echo $post->ID; ?>" :sector="true">
            <?php if($related_posts_by_sector) : ?>
                <section class="knowledge-centre__list" style="display:none;">
                    <?php foreach($related_posts_by_sector as $item) : ?>
                        <div class="masonry__item">
                            <?php if($item['categories'][0]->slug === 'videos') : ?>
                                <a href="<?= $item['url']; ?>" class="masonry__item__wrapper masonry__item__wrapper--videos">
                                    <div class="masonry__item__image">
                                        <div class="masonry__item__icon-play"></div>
                                        <?php
                                            $imageVar = $item['bg'];
                                            $imageClass = 'masonry__item__image__bg';
                                            include( locate_template( 'partials/image-srcset.php', false, false ) );
                                        ?>
                                        <?php if($item['gradient']) : ?>
                                            <div class="masonry__item__gradient"></div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="masonry__item__content">
                                        <div class="masonry__item__category"><?= $item['categories'][0]->name; ?></div>
                                        <div class="masonry__item__title"><?= $item['title']; ?></div>
                                        <div class="btn btn--video">Watch</div>
                                    </div>
                                </a>
                            <?php endif; ?>
                            
                            <?php if($item['categories'][0]->slug === 'news-articles') : ?>
                                <a href="<?= $item['url']; ?>" class="masonry__item__wrapper">
                                    <div class="masonry__item__image">
                                        <img src="<?= $item['bg']['sizes']['largeRetina']; ?>" alt="" width="100" height="100" class="masonry__item__image__bg">
                                        <?php if($item['gradient']) : ?>
                                            <div class="masonry__item__gradient"></div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="masonry__item__content">
                                        <div class="masonry__item__category"><?= $item['categories'][0]->name; ?></div>
                                        <div class="masonry__item__title"><?= $item['title']; ?></div>
                                    </div>
                                </a>
                            <?php endif; ?>
                            
                            <?php if($item['categories'][0]->slug === 'resources') : ?>
                                <a href="<?= $item['url']; ?>" class="masonry__item__wrapper">
                                    <div class="masonry__item__image">
                                        <?php
                                            $imageVar = $item['bg'];
                                            $imageClass = 'masonry__item__image__bg';
                                            include( locate_template( 'partials/image-srcset.php', false, false ) );
                                        ?>
                                        <?php if($item['gradient']) : ?>
                                            <div class="masonry__item__gradient"></div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="masonry__item__content">
                                        <div class="masonry__item__category"><?= $item['categories'][0]->name; ?></div>
                                        <div class="masonry__item__title"><?= $item['title']; ?></div>
                                    </div>
                                </a>
                            <?php endif; ?>
                            
                            <?php if($item['categories'][0]->slug === 'research-case-studies') : ?>
                                <a href="<?= $item['url']; ?>" class="masonry__item__wrapper">
                                    <div class="masonry__item__image">
                                        <img src="<?= $item['logo']['url']; ?>" width="100" height="100" alt="<?= $item['title']; ?>" class="masonry__item__image__bg">
                                    </div>
                                    <div class="masonry__item__content">
                                        <div class="masonry__item__category"><?= $item['categories'][0]->name; ?></div>
                                        <div class="masonry__item__title"><?= $item['title']; ?></div>
                                    </div>
                                </a>
                            <?php endif; ?>
                            
                            <?php if($item['categories'][0]->slug === 'testimonials') : ?>
                                <div class="masonry__item__wrapper masonry__item__wrapper--quote">
                                    <div class="masonry__item__icon" style="background-image: url(<?= $item['categories_icon']['url']; ?>)"></div>
                                    <div class="masonry__item__quote"><?= $item['quote']; ?></div>
                                    <div class="masonry__item__author"><?= $item['author']; ?></div>
                                </div>
                            <?php endif; ?>                            
                        </div>
                    <?php endforeach; ?>
                    <div class="masonry__item-size"></div>
                </section>
            <?php endif; ?>
        </knowledge-centre-list>
    </div>
</section>