<?php
    $term = get_queried_object();
    // API CALL
    $request = new WP_REST_Request( 'POST', '/post/products' );
    $request->set_query_params( [ 'taxonomy' => json_encode($term, JSON_HEX_APOS) ] );
    $response = rest_do_request( $request );
    $server = rest_get_server();
    $data = $server->response_to_data( $response, false )["products"];
?>

<section class="products bg-silver">
    <div class="container">
        <div class="products__title">
            <h1>Products</h1>
        </div>
        <div class="products__wrapper">
            <aside class="products__filter">
                <product-search>
                    <div>
                        <div class="product-search-label">
                            <span>Search</span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="42.511" height="42.511" viewBox="0 0 42.511 42.511">
                                <g data-name="Group 49" transform="rotate(45 732.19 -358.775)" fill="#fff">
                                    <path data-name="Path 158" d="M502.872 412.654a11.576 11.576 0 11-11.572-11.576 11.575 11.575 0 0111.572 11.576zm-11.572-8.346a8.345 8.345 0 108.345 8.345 8.345 8.345 0 00-8.345-8.345z"></path>
                                    <rect data-name="Rectangle 114" width="17.048" height="3.7" rx="1.85" transform="translate(499.642 410.804)"></rect>
                                </g>
                            </svg>
                        </div>
                    </div>
                </product-search>
                <div class="products__filter__title">Filter</div>
                <div class="products__filter__group <?php echo ( $term->taxonomy === 'service' ) ? 'is-active' : null; ?>">
                    <div class="products__filter__group__btn">
                        Service
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14">
                            <g id="icon-plus" transform="translate(-238.5 -591.5)">
                                <g id="Group_303" data-name="Group 303" transform="translate(133)">
                                    <line id="Line_3" data-name="Line 3" y1="14" transform="translate(112.5 591.5)" fill="none" stroke="#fff" stroke-width="1"/>
                                    <line id="Line_4" data-name="Line 4" y1="14" transform="translate(119.5 598.5) rotate(90)" fill="none" stroke="#fff" stroke-width="1"/>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <div class="products__filter__group__container">
                        <?php
                            $services = get_terms( array(
                                'taxonomy' => 'service',
                                'hide_empty' => false
                            ) );

                            foreach ( $services as $service ) :
                        ?>
                            <a href="/<?php echo $service->taxonomy; ?>/<?php echo $service->slug; ?>"
                               title="<?php echo $service->name; ?>"
                               class="<?php echo ( $term->name === $service->name ) ? 'is-active' : null; ?>"
                            ><?php echo $service->name; ?></a>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="products__filter__group <?php echo ( $term->taxonomy === 'product-type' ) ? 'is-active' : null; ?>">
                    <div class="products__filter__group__btn">
                        Product type
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14">
                            <g id="icon-plus" transform="translate(-238.5 -591.5)">
                                <g id="Group_303" data-name="Group 303" transform="translate(133)">
                                    <line id="Line_3" data-name="Line 3" y1="14" transform="translate(112.5 591.5)" fill="none" stroke="#fff" stroke-width="1"/>
                                    <line id="Line_4" data-name="Line 4" y1="14" transform="translate(119.5 598.5) rotate(90)" fill="none" stroke="#fff" stroke-width="1"/>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <div class="products__filter__group__container">
                        <?php
                            $ProductType = get_terms( array(
                                'taxonomy' => 'product-type',
                                'hide_empty' => false
                            ) );

                            foreach ( $ProductType as $type ) :
                        ?>
                            <a href="/<?php echo $type->taxonomy; ?>/<?php echo $type->slug; ?>"
                               title="<?php echo $type->name; ?>"
                               class="<?php echo ( $term->name === $type->name ) ? 'is-active' : null; ?>"
                            ><?php echo $type->name; ?></a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </aside>
            <div class="products__container">
                <?php
                    $banner = get_field('banner', $term);
                ?>
                <?php if ( $banner ) : ?>
                    <div class="products__banner">
                        <div class="box-product-taxonomy">
                            <?php
                                $imageVar = $banner['background'];
                                $imageClass = 'box-product-taxonomy__bg';
                                include( locate_template( 'partials/image-srcset.php', false, false ) );
                            ?>
                            <div class="box-product-taxonomy__wrapper">
                                <div class="box-product-taxonomy__title"><?php single_term_title(); ?></div>
                                <div class="box-product-taxonomy__content">
                                    <?php echo $banner['content']; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="products__wrapper-list">
                    <div class="loading bg-silver">
                        <svg width="42.613" height="46.167" viewBox="0 0 32.613 36.167">
                            <g id="Group_412" data-name="Group 412" transform="translate(-96 -580.917)">
                                <path id="Path_2048" data-name="Path 2048" d="M42.267,27.307a3.318,3.318,0,0,0-1.66.445L29.12,34.383a3.321,3.321,0,0,0-1.66,2.876V50.521A3.321,3.321,0,0,0,29.12,53.4l11.486,6.631a3.322,3.322,0,0,0,3.321,0L55.412,53.4a3.321,3.321,0,0,0,1.661-2.876V37.259a3.321,3.321,0,0,0-1.661-2.876L43.927,27.752a3.319,3.319,0,0,0-1.66-.445Z" transform="translate(70.04 555.11)" fill="none" stroke="#494949" stroke-width="3"/>
                                <g id="Group_347" data-name="Group 347" transform="translate(-657.138 -1934.001)">
                                    <circle id="Ellipse_432" data-name="Ellipse 432" cx="1" cy="1" r="1" transform="translate(762.991 2532.198)" fill="#494949"/>
                                    <circle id="Ellipse_433" data-name="Ellipse 433" cx="1" cy="1" r="1" transform="translate(767.991 2532.198)" fill="#494949"/>
                                    <circle id="Ellipse_434" data-name="Ellipse 434" cx="1" cy="1" r="1" transform="translate(772.991 2532.198)" fill="#494949"/>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <products taxonomy='<?php echo json_encode($term, JSON_HEX_APOS); ?>'>
                        <div style="display:none;">
                            <div class="products__list-options">
                                <div class="products__list-options__item is-active">All Products</div>
                                <div class="products__list-options__view">
                                    <div class="products__list-options__view__grid">
                                        <svg id="icon-grid" xmlns="http://www.w3.org/2000/svg" width="14.898" height="14.898" viewBox="0 0 14.898 14.898">
                                            <path id="Path_2193" data-name="Path 2193" d="M0,0H6.518V6.518H0Z" fill="#202020"/>
                                            <path id="Path_2194" data-name="Path 2194" d="M0,8.38H6.518V14.9H0ZM8.38,0H14.9V6.518H8.38Z" fill="#202020"/>
                                            <path id="Path_2195" data-name="Path 2195" d="M36,36h6.518v6.518H36Z" transform="translate(-27.62 -27.62)" fill="#202020"/>
                                        </svg>
                                    </div>
                                    <div class="products__list-options__view__list">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18.067" height="13.206" viewBox="0 0 18.067 13.206">
                                            <g id="icon-list">
                                                <ellipse id="Ellipse_436" data-name="Ellipse 436" cx="1.165" cy="1.165" rx="1.165" ry="1.165" transform="translate(0 0)" fill="#202020"/>
                                                <path id="Path_2196" data-name="Path 2196" d="M22,14H34.045" transform="translate(-15.978 -12.796)" fill="none" stroke="#202020" stroke-linejoin="round" stroke-width="2"/>
                                                <ellipse id="Ellipse_437" data-name="Ellipse 437" cx="1.165" cy="1.165" rx="1.165" ry="1.165" transform="translate(0 5.438)" fill="#202020"/>
                                                <path id="Path_2197" data-name="Path 2197" d="M22,32H34.045" transform="translate(-15.978 -25.375)" fill="none" stroke="#202020" stroke-linejoin="round" stroke-width="2"/>
                                                <ellipse id="Ellipse_438" data-name="Ellipse 438" cx="1.165" cy="1.165" rx="1.165" ry="1.165" transform="translate(0 10.875)" fill="#202020"/>
                                                <path id="Path_2198" data-name="Path 2198" d="M22,50H34.045" transform="translate(-15.978 -37.955)" fill="none" stroke="#202020" stroke-linejoin="round" stroke-width="2"/>
                                            </g>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="products__list row">
                                <?php if($data) :
                                    foreach($data as $item) : ?>
                                    <div class="products__list__item col">
                                        <a href="<?= $item['url']; ?>" title="View" class="box-product__wrapper">
                                            <div class="box-product__image">
                                                <?php
                                                    $imageVar = $item['box']['image'];
                                                    $imageClass = '';
                                                    include( locate_template( 'partials/image-srcset.php', false, false ) );
                                                ?>
                                            </div>
                                            <h4 class="box-product__title">
                                                <span><?= $item['title']; ?></span>
                                                <?php if($item['title'] && $item['title'] != '') : ?>
                                                    <span>/ <?= $item['box']['code']; ?></span>
                                                <?php endif; ?>
                                            </h4>
                                            <div class="box-product__excerpt"><?= $item['box']['excerpt']; ?></div>
                                            <div class="box-product__sizes">
                                                <?php if($item['box']['sizes']) : ?>
                                                    <strong>Dimensions:</strong><br>
                                                    <?= $item['box']['sizes']; ?>
                                                <?php endif; ?>
                                            </div>
                                            <div class="box-product__btn btn btn--view">View</div>
                                        </a>
                                    </div>
                                    <?php endforeach; endif; ?>
                                <div class="products__list__item-last"></div>
                            </div>
                        </div>
                    </products>
                </div>
            </div>
        </div>
    </div>
</section>