<?php
    $heading = get_sub_field('heading');
    $download = get_sub_field('download');
?>
<?php if ( $download ) : ?>
    <div class="product__downloads">
        <?php if ( $heading ) : ?>
            <p><strong><?php echo $heading; ?></strong></p>
        <?php endif; ?>
        <?php foreach ( $download as $item ) : ?>
            <?php
                $type = $item['type'];
                $url = ( $type === 'file' ) ? $item['file']['url'] : $item['link'];
                $label = $item['label'];
            ?>
            <a href="<?php echo $url; ?>"
               target="_blank"
               rel="noopener noreferrer"
               class="product__downloads__file <?php echo ( $type === 'link' ) ? 'product__downloads__file--link' : null; ?>">
                <span class="product__downloads__file__label"><?php echo $label; ?></span>
                <i class="product__downloads__file__icon"></i>
            </a>
        <?php endforeach; ?>
    </div>
<?php endif; ?>