<?php
$heading = get_field('heading');
?>
<div class="product__content">
    <?php if ($heading) : ?>
        <h4 class="heading-border"><?php echo $heading; ?></h4>
    <?php endif; ?>

    <?php
    get_template_part('sections/product/content_description');

    $parentID = null;

    $child_args = array(
        'post_parent' => $post->ID,
        'post_type'   => 'product',
        'post_status' => 'publish',
    );

    $children = get_children($child_args);

    $list = [];

    if ($post->post_parent) :
        $parentID = $post->post_parent;
        $p = get_post($post->post_parent);

        $list[] = [
            'name' => get_the_title($p),
            'slug' => $p->post_name,
            'code' => get_field('product_code', $p),
            'sizes' => get_field('product_sizes',  $p)
        ];

    elseif (count($children) > 0) :
        $parentID = $post->ID;
        // $list[] = [
        //     'name' => get_the_title(),
        //     'slug' => $post->post_name,
        //     'code' => get_field('product_code'),
        //     'sizes' => get_field('product_sizes')
        // ];
    endif;

    if ($parentID != null) :

        $args = array(
            'post_type'      => 'product',
            'posts_per_page' => -1,
            'post_parent'    => $parentID,
            'order'          => 'ASC',
            'orderby'        => 'menu_order'
        );

        $parent = new WP_Query($args);

        $curr_slug = $post->post_name;

        while ($parent->have_posts()) : $parent->the_post();


            $list[] =
                [
                    'name' => get_the_title(),
                    'slug' => $post->post_name,
                    'code' => get_field('product_code'),
                    'sizes' => get_field('product_sizes')
                ];
        endwhile;
        wp_reset_postdata();
        ?>
        <product-variants slug="<?php echo $curr_slug; ?>" data_items='<?php echo json_encode($list); ?>'>
            <nav class="variants-dropdown">
                <button>Alternative options</button>
                <ul style="display:none">
                    <?php foreach( $list as $item ) : ?>
                        <li >
                            <a href="<?php echo get_site_url(); ?>/product/<?php echo $curr_slug.'/'.$item['slug']; ?>">
                                <span><?php echo $item['code']; ?></span>
                                <span><?php echo $item['name']; ?></span>
                                <span><?php echo $item['sizes']; ?></span>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </nav>
        </product-variants>
    <?php endif; ?>



    <?php
    get_template_part('sections/product/content_specifications');

    if ($post->post_parent && !get_field('get_this_content')) :
        $post = get_post($post->post_parent);
    endif;

    // Check value exists.
    if (have_rows('content')) :

        // Loop through rows.
        while (have_rows('content')) : the_row();

            // Case: Content layout.
            if (get_row_layout() == 'content') :
                get_template_part('sections/product/content_content');

            // Case: Accordion layout.
            elseif (get_row_layout() == 'accordion') :
                get_template_part('sections/product/content_accordion');

            // Case: Download layout.
            elseif (get_row_layout() == 'download') :
                get_template_part('sections/product/content_download');

            // Case: Video layout.
            elseif (get_row_layout() == 'video') :
                get_template_part('sections/product/content_video');

            endif;

        // End loop.
        endwhile;

    // No value.
    else :
    // Do something...
    endif;
    ?>
</div>