<?php
    $titlePage = get_the_title();
    $mainMenu = get_field('main_menu', 'options');
    $solutions = $mainMenu['solutions'];


    $header = get_field('header', 'options');
    $containerTitle = $header['menu_ref'][0]['link']['title'];

?>
<div class="main-menu__container main-menu__container--solutions container">
    <div class="main-menu__container-title"><?php echo $containerTitle; ?></div>
    <div class="main-menu__left">
        <div class="main-menu__label"><?php echo $solutions['heading']; ?></div>
        <div class="main-menu__links">
            <?php
                // Custom WP query query_sector
                $args_query_sector_link = array(
                    'post_type' => array('sector'),
                    'posts_per_page' => -1,
                    'order' => 'DESC',
                );

                $query_sector_link = new WP_Query( $args_query_sector_link );

                if ( $query_sector_link->have_posts() ) :
            ?>
                <?php while ($query_sector_link->have_posts()) : $query_sector_link->the_post(); ?>
                    <a href="<?php echo get_the_permalink(); ?>"
                       class="main-menu__link <?php echo ( $titlePage === get_the_title()  ) ? 'is-active' : null; ?>"
                       title="<?php the_title(); ?>"
                    ><?php the_title(); ?></a>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            <?php endif;?>
        </div>
        <a href="/solutions" class="btn btn--arrow-blue" title="View all">View all</a>
    </div>
    <div class="main-menu__right">
        <div class="main-menu__label">&nbsp;</div>
        <?php
            // Custom WP query query_sector
            $args_query_sector_box = array(
                'post_type' => array('sector'),
                'posts_per_page' => -1,
                'order' => 'DESC',
            );

            $query_sector_box = new WP_Query( $args_query_sector_box );

            if ( $query_sector_box->have_posts() ) :
        ?>
            <?php while ($query_sector_box->have_posts()) : $query_sector_box->the_post(); ?>
                <?php
                    $box = get_field('box');
                    $title = $box['title'];
                    $image = $box['background'];
                    $content = $box['content'];
                ?>
                <a class="main-menu__sector <?php echo ( $titlePage === get_the_title()  ) ? 'is-active' : null; ?>"
                   href="<?php echo get_the_permalink(); ?>"
                   title="<?php echo $title; ?>"
                >
                    <picture class="main-menu__lazy-img">
                        <?php if ( $image['mime_type'] != 'image/svg+xml' ) : ?>
                        <source
                            type="image/webp"
                            data-srcset="<?php echo $image['sizes']['large']; ?>.webp 1024w,
                            <?php echo $image['sizes']['medium_large']; ?>.webp 600w,
                            <?php echo $image['sizes']['medium']; ?>.webp 320w">
                        <source
                            type="<?php echo $image['mime_type']; ?>"
                            data-srcset="<?php echo $image['sizes']['large']; ?> 1024w,
                            <?php echo $image['sizes']['medium_large']; ?> 600w,
                            <?php echo $image['sizes']['medium']; ?> 320w" >
                            <img class="" width="400" height="300" src="" data-src="<?php echo $image['sizes']['placeholder']; ?>" alt="<?php echo $image['alt']; ?>">
                        <?php else : ?>
                            <img class="" width="400" height="300" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                        <?php endif; ?>
                    </picture>
                    <div class="main-menu__sector__title">
                        <p><?php echo $title; ?></p>
                        <span class="main-menu__sector__content"><?php echo $content; ?></span>
                    </div>
                </a>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
        <?php endif;?>
    </div>
</div>