<?php
    $mainMenu = get_field('main_menu', 'options');

    $term = get_queried_object();

    $header = get_field('header', 'options');
    $containerTitle = $header['menu_ref'][1]['link']['title'];

    $products = $mainMenu['products'];
    $insight = $products['product_insight'];
?>
<div class="main-menu__container main-menu__container--products container">
    <div class="main-menu__container-title"><?php echo $containerTitle; ?></div>
    <div class="main-menu__left">
        <div class="main-menu__tabs">
            <div class="main-menu__tabs__nav">
                <div class="main-menu__tabs__tab is-active">Services</div>
                <div class="main-menu__tabs__tab">Product Type</div>
                <div class="main-menu__tabs__tab"><?php echo $insight['heading']; ?></div>
            </div>
            <div class="main-menu__tabs__content is-active">
                <div class="main-menu__links">
                    <?php
                        $services = get_terms( array(
                            'taxonomy' => 'service',
                            'hide_empty' => false
                        ) );

                        foreach ( $services as $service ) :
                    ?>
                        <a href="/<?php echo $service->taxonomy; ?>/<?php echo $service->slug; ?>"
                           title="<?php echo $service->name; ?>"
                           class="main-menu__link <?php echo ( $term->name === $service->name ) ? 'is-active' : null; ?>"
                        ><?php echo $service->name; ?></a>
                    <?php endforeach; ?>
                </div>
                <a href="/products" class="btn btn--arrow-blue" title="View all">View all</a>
            </div>
            <div class="main-menu__tabs__content">
                <div class="main-menu__links">
                    <?php
                        $productsType = get_terms( array(
                            'taxonomy' => 'product-type',
                            'hide_empty' => false
                        ) );

                        foreach ( $productsType as $productType ) :
                    ?>
                        <a href="/<?php echo $productType->taxonomy; ?>/<?php echo $productType->slug; ?>"
                           title="<?php echo $productType->name; ?>"
                           class="main-menu__link <?php echo ( $term->name === $productType->name ) ? 'is-active' : null; ?>"
                        ><?php echo $productType->name; ?></a>
                    <?php endforeach; ?>
                </div>
                <a href="/products" class="btn btn--arrow-blue" title="View all">View all</a>
            </div>
            <div class="main-menu__tabs__content">
                <div class="main-menu__links">
                    <?php foreach ( $insight['links'] as $link ) : ?>
                        <a href="<?php echo get_the_permalink($link['link']->ID); ?>"
                           title="<?php echo $link['link']->post_title; ?>"
                           class="main-menu__link"
                        ><?php echo $link['link']->post_title; ?></a>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="main-menu__right">
        <div class="main-menu__right__content is-active">
            <div class="main-menu__label">Product overviews</div>
            <div class="main-menu__products-btn">
                <?php
                    $productID = $post->ID;

                    $args = array(
                        'post_type'      => 'page',
                        'posts_per_page' => -1,
                        'post_parent'    => 138,
                        'child_of'       => 138,
                        'order'          => 'ASC',
                        'orderby'        => 'menu_order'
                    );

                    $parent = new WP_Query( $args );

                    if ( $parent->have_posts() ) :
                ?>
                    <?php while ( $parent->have_posts() ) : $parent->the_post(); ?>
                    <?php
                        $icon = get_field('icon_product');
                        $iconWhite = get_field('icon_product_white');
                    ?>

                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="btn btn-product <?php echo ( $productID === $post->ID ) ? 'is-active' : null; ?>">
                            <div class="btn-product__icon-wrapper">
                                <i class="btn-product__icon" data-style="background-image: url('<?php echo $icon['url']; ?>');"></i>
                                <i class="btn-product__icon btn-product__icon--white" data-style="background-image: url('<?php echo $iconWhite['url']; ?>');"></i>
                            </div>
                            <?php the_title(); ?>
                        </a>

                <?php endwhile; ?>
                <?php endif; wp_reset_query(); ?>
            </div>
        </div>
    </div>
</div>