<?php
    $mainMenu = get_field('main_menu', 'options');
    $knowledgeCentre = $mainMenu['knowledge_centre'];

    $links = $knowledgeCentre['menu']['links'];
    $viewAll = $knowledgeCentre['menu']['view_all'];

    $header = get_field('header', 'options');
    $containerTitle = $header['menu_ref'][2]['link']['title'];

    $boxes = $knowledgeCentre['boxes'];
?>
<div class="main-menu__container main-menu__container--knowledge-centre container">
    <div class="main-menu__container-title"><?php echo $containerTitle; ?></div>
    <div class="main-menu__left main-menu__left--knowledge-centre">
        <div class="main-menu__label">
            <a href="<?php echo $viewAll['url']; ?>" class="btn btn--arrow-blue" title="<?php echo $knowledgeCentre['menu']['heading']; ?>">
                <strong><?php echo $knowledgeCentre['menu']['heading']; ?></strong>
            </a>
        </div>
        <div class="main-menu__links">
            <?php foreach ( $links as $link ) : ?>
                <a href="<?php echo $viewAll['url']; ?>?category=<?php echo $link->slug; ?>" class="main-menu__link" title="<?php echo $link->name; ?>"><?php echo $link->name; ?></a>
            <?php endforeach; ?>
        </div>
        <a href="<?php echo $viewAll['url']; ?>" class="btn btn--arrow-blue" title="View all">View all</a>
    </div>
    <div class="main-menu__right main-menu__right--featured">
        <div class="main-menu__label"><?php echo $knowledgeCentre['heading']; ?></div>
        <div class="main-menu__features">
            <?php
                $boxLeft =  $boxes['left']['box'];
                $image = $boxLeft['background_image_var'];
            ?>
            <a class="main-menu__featured"
               href="<?php echo $boxLeft['url']; ?>"
               title="<?php echo $boxLeft['title']; ?>"
            >
                <picture class="main-menu__lazy-img">
                    <?php if ( $image['mime_type'] != 'image/svg+xml' ) : ?>
                    <source
                        type="image/webp"
                        data-srcset="<?php echo $image['sizes']['large']; ?>.webp 1024w,
                        <?php echo $image['sizes']['medium_large']; ?>.webp 600w,
                        <?php echo $image['sizes']['medium']; ?>.webp 320w">
                    <source
                        type="<?php echo $image['mime_type']; ?>"
                        data-srcset="<?php echo $image['sizes']['large']; ?> 1024w,
                        <?php echo $image['sizes']['medium_large']; ?> 600w,
                        <?php echo $image['sizes']['medium']; ?> 320w" >
                        <img class="" width="400" height="300" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                    <?php else : ?>
                        <img class="" width="400" height="300" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                    <?php endif; ?>
                </picture>
                <div class="main-menu__featured__wrapper">
                    <p class="main-menu__featured__category"><?php echo $boxLeft['heading']; ?></p>
                    <p class="main-menu__featured__title"><?php echo $boxLeft['title']; ?></p>
                    <p class="main-menu__featured__excerpt"><?php echo $boxLeft['content']; ?></p>
                    <p class="main-menu__featured__btn btn btn--more">Learn more</p>
                </div>
            </a>
            <?php
                $boxRight =  $boxes['right']['box'];
                $image = $boxRight['background_image_var'];
            ?>
            <a class="main-menu__featured"
               href="<?php echo $boxRight['url']; ?>"
               title="<?php echo $boxRight['title']; ?>"
            >
                <picture class="main-menu__lazy-img">
                    <?php if ( $image['mime_type'] != 'image/svg+xml' ) : ?>
                    <source
                        type="image/webp"
                        data-srcset="<?php echo $image['sizes']['large']; ?>.webp 1024w,
                        <?php echo $image['sizes']['medium_large']; ?>.webp 600w,
                        <?php echo $image['sizes']['medium']; ?>.webp 320w">
                    <source
                        type="<?php echo $image['mime_type']; ?>"
                        data-srcset="<?php echo $image['sizes']['large']; ?> 1024w,
                        <?php echo $image['sizes']['medium_large']; ?> 600w,
                        <?php echo $image['sizes']['medium']; ?> 320w" >
                        <img class="" width="400" height="300" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                    <?php else : ?>
                        <img class="" width="400" height="300" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                    <?php endif; ?>
                </picture>
                <div class="main-menu__featured__wrapper">
                    <p class="main-menu__featured__category"><?php echo $boxRight['heading']; ?></p>
                    <p class="main-menu__featured__title"><?php echo $boxRight['title']; ?></p>
                    <p class="main-menu__featured__excerpt"><?php echo $boxRight['content']; ?></p>
                    <p class="main-menu__featured__btn btn btn--more">Learn more</p>
                </div>
            </a>
        </div>
    </div>
</div>