<?php
    $mainMenu = get_field('main_menu', 'options');
    $company = $mainMenu['company'];

    $links = $company['menu']['links_rep'];

    $boxes = $company['boxes'];

    $header = get_field('header', 'options');
    $containerTitle = $header['menu_ref'][3]['link']['title'];
?>
<div class="main-menu__container main-menu__container--company container">
    <div class="main-menu__container-title"><?php echo $containerTitle; ?></div>
    <div class="main-menu__left main-menu__left--company">
        <div class="main-menu__label">
            <strong><?php echo $company['menu']['heading']; ?></strong>
        </div>
        <div class="main-menu__links">
            <?php
                global $wp;
                $current_url = home_url(add_query_arg(array(), $wp->request));
            ?>
            <?php foreach ( $links as $link ) : ?>
                <a href="<?php echo $link['page_link']['url']; ?>"
                   class="main-menu__link <?php echo ( $current_url . '/' === $link['page_link']['url'] ) ? 'is-active' : null; ?>"
                   title="<?php echo $link['page_link']['title']; ?>"
                ><?php echo $link['page_link']['title']; ?></a>
            <?php endforeach; ?>
        </div>
    </div>
    <div class="main-menu__right main-menu__right--featured">
        <div class="main-menu__features">
            <div class="main-menu__label"><?php echo $boxes['left']['heading']; ?></div>
            <div class="main-menu__label"><?php echo $boxes['right']['heading']; ?></div>
        </div>
        <div class="main-menu__features">
            <?php
                $boxLeft =  $boxes['left']['box'];
                $image = $boxLeft['background_image_var'];
            ?>
            <a class="main-menu__featured"
               href="<?php echo $boxLeft['url']; ?>"
               title="<?php echo $boxLeft['title']; ?>"
            >
                <picture class="main-menu__lazy-img">
                    <?php if ( $image['mime_type'] != 'image/svg+xml' ) : ?>
                    <source
                        type="image/webp"
                        data-srcset="<?php echo $image['sizes']['large']; ?>.webp 1024w,
                        <?php echo $image['sizes']['medium_large']; ?>.webp 600w,
                        <?php echo $image['sizes']['medium']; ?>.webp 320w">
                    <source
                        type="<?php echo $image['mime_type']; ?>"
                        data-srcset="<?php echo $image['sizes']['large']; ?> 1024w,
                        <?php echo $image['sizes']['medium_large']; ?> 600w,
                        <?php echo $image['sizes']['medium']; ?> 320w" >
                        <img class="" width="400" height="300" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                    <?php else : ?>
                        <img class="" width="400" height="300" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                    <?php endif; ?>
                </picture>
                <div class="main-menu__featured__wrapper">
                    <p class="main-menu__featured__category"><?php echo $boxLeft['heading']; ?></p>
                    <p class="main-menu__featured__title"><?php echo $boxLeft['title']; ?></p>
                    <p class="main-menu__featured__excerpt"><?php echo $boxLeft['dontent']; ?></p>
                    <p class="main-menu__featured__btn btn btn--more">Learn more</p>
                </div>
            </a>
            <?php
                $boxRight =  $boxes['right']['box'];
                $image = $boxRight['background_image_var'];
            ?>
            <a class="main-menu__featured"
               href="<?php echo $boxRight['url']; ?>"
               title="<?php echo $boxRight['title']; ?>"
            >
                <picture class="main-menu__lazy-img">
                    <?php if ( $image['mime_type'] != 'image/svg+xml' ) : ?>
                    <source
                        type="image/webp"
                        data-srcset="<?php echo $image['sizes']['large']; ?>.webp 1024w,
                        <?php echo $image['sizes']['medium_large']; ?>.webp 600w,
                        <?php echo $image['sizes']['medium']; ?>.webp 320w">
                    <source
                        type="<?php echo $image['mime_type']; ?>"
                        data-srcset="<?php echo $image['sizes']['large']; ?> 1024w,
                        <?php echo $image['sizes']['medium_large']; ?> 600w,
                        <?php echo $image['sizes']['medium']; ?> 320w" >
                        <img class="" width="400" height="300" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                    <?php else : ?>
                        <img class="" width="400" height="300" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                    <?php endif; ?>
                </picture>
                <div class="main-menu__featured__wrapper">
                    <p class="main-menu__featured__category"><?php echo $boxRight['heading']; ?></p>
                    <p class="main-menu__featured__title"><?php echo $boxRight['title']; ?></p>
                    <p class="main-menu__featured__excerpt"><?php echo $boxRight['dontent']; ?></p>
                    <p class="main-menu__featured__btn btn btn--more">Learn more</p>
                </div>
            </a>
        </div>
    </div>
</div>