<?php
    $section = get_field('learn_more', 'options');
?>
<section class="learn-more">
    <div class="container">
        <h2 class="heading-border"><?php echo $section['heading']; ?></h2>
        <div class="learn-more__wrapper row">
            <?php foreach ( $section['boxes'] as $box ) : ?>
                <div class="col">
                    <a class="learn-more__item" href="<?php echo $box['url']; ?>">
                        <?php
                            $imageVar = $box['background_image'];
                            $imageClass = 'learn-more__item__bg';
                            include( locate_template( 'partials/image-srcset.php', false, false ) );
                        ?>
                        <div class="learn-more__item__title"><?php echo $box['title']; ?></div>
                        <span class="learn-more__item__btn btn btn--more"><?php echo $box['button_label']; ?></span>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>