<?php
    $term = get_the_terms( $post->ID, 'knowledge-centre-category');

    $poster = get_field('background_image')['url'];
    $video = get_field('video');
?>
<article class="post">
    <div class="post__container container">
        <div class="post__wrapper">
            <div class="post__share post__share--mobile">
                <div class="post__share__btn">
                    Share
                </div>
                <div class="post__share__wrapper">
                    <?php echo get_social_share_56('social-share-wrapper', array('twitter', 'facebook', 'linkedin', 'google')); ?>
                </div>
            </div>
            <div class="post__title post__title--video content">
                <h6><?php echo $term[0]->name; ?></h6>
                <h1><?php the_title(); ?></h1>
            </div>
            <div class="post__video">
                <video preload="none" playsinline loop controls poster="<?php echo $poster; ?>">
                    <source src="<?php echo $video; ?>" type="video/mp4" />
                </video>
            </div>
            <div class="post__info">
                <p><?php the_time( 'M j, Y' ); ?></p>
            </div>
        </div>
        <aside class="post__aside">
            <div class="post__share">
                <div class="post__share__btn">
                    Share
                </div>
                <div class="post__share__wrapper">
                    <?php echo get_social_share_56('social-share-wrapper', array('twitter', 'facebook', 'linkedin', 'google')); ?>
                </div>
            </div>
            <?php get_template_part('sections/knowledge-centre/post-related'); ?>
        </aside>
    </div>
</article>