<?php
$request = new WP_REST_Request( 'GET', '/get/knowledge-centre' );
$response = rest_do_request( $request );
$server = rest_get_server();
$data = $server->response_to_data( $response, false )['posts'];

$home_kc_posts = array();

foreach($data as $item) {
    if ( !$item['show_home'] && $item['show_home'] === NULL ) {
        $home_kc_posts[] = $item;
    }   
} ?>
<section class="featured-content">
    <div class="container">
        <h2 class="heading-border">Featured Content</h2>

        <div class="knowledge-centre__wrapper-list">
            <div class="loading bg-white">
                <svg width="42.613" height="46.167" viewBox="0 0 32.613 36.167">
                    <g id="Group_412" data-name="Group 412" transform="translate(-96 -580.917)">
                        <path id="Path_2048" data-name="Path 2048" d="M42.267,27.307a3.318,3.318,0,0,0-1.66.445L29.12,34.383a3.321,3.321,0,0,0-1.66,2.876V50.521A3.321,3.321,0,0,0,29.12,53.4l11.486,6.631a3.322,3.322,0,0,0,3.321,0L55.412,53.4a3.321,3.321,0,0,0,1.661-2.876V37.259a3.321,3.321,0,0,0-1.661-2.876L43.927,27.752a3.319,3.319,0,0,0-1.66-.445Z" transform="translate(70.04 555.11)" fill="none" stroke="#494949" stroke-width="3"/>
                        <g id="Group_347" data-name="Group 347" transform="translate(-657.138 -1934.001)">
                            <circle id="Ellipse_432" data-name="Ellipse 432" cx="1" cy="1" r="1" transform="translate(762.991 2532.198)" fill="#494949"/>
                            <circle id="Ellipse_433" data-name="Ellipse 433" cx="1" cy="1" r="1" transform="translate(767.991 2532.198)" fill="#494949"/>
                            <circle id="Ellipse_434" data-name="Ellipse 434" cx="1" cy="1" r="1" transform="translate(772.991 2532.198)" fill="#494949"/>
                        </g>
                    </g>
                </svg>
            </div>
            <knowledge-centre-list :sector="true" :home="true">
                <?php if($home_kc_posts) : ?>
                    <section class="knowledge-centre__list" style="display:none;">
                        <?php foreach($home_kc_posts as $item) : ?>
                            <div class="masonry__item">
                                <?php if($item['categories'][0]->slug === 'videos') : ?>
                                    <a href="<?= $item['url']; ?>" class="masonry__item__wrapper masonry__item__wrapper--videos">
                                        <div class="masonry__item__image">
                                            <div class="masonry__item__icon-play"></div>
                                            <?php
                                                $imageVar = $item['bg'];
                                                $imageClass = 'masonry__item__image__bg';
                                                include( locate_template( 'partials/image-srcset.php', false, false ) );
                                            ?>
                                            <?php if($item['gradient']) : ?>
                                                <div class="masonry__item__gradient"></div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="masonry__item__content">
                                            <div class="masonry__item__category"><?= $item['categories'][0]->name; ?></div>
                                            <div class="masonry__item__title"><?= $item['title']; ?></div>
                                            <div class="btn btn--video">Watch</div>
                                        </div>
                                    </a>
                                <?php endif; ?>
                                
                                <?php if($item['categories'][0]->slug === 'news-articles') : ?>
                                    <a href="<?= $item['url']; ?>" class="masonry__item__wrapper">
                                        <div class="masonry__item__image">
                                            <img src="<?= $item['bg']['sizes']['largeRetina']; ?>" alt="" width="100" height="100" class="masonry__item__image__bg">
                                            <?php if($item['gradient']) : ?>
                                                <div class="masonry__item__gradient"></div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="masonry__item__content">
                                            <div class="masonry__item__category"><?= $item['categories'][0]->name; ?></div>
                                            <div class="masonry__item__title"><?= $item['title']; ?></div>
                                        </div>
                                    </a>
                                <?php endif; ?>
                                
                                <?php if($item['categories'][0]->slug === 'resources') : ?>
                                    <a href="<?= $item['url']; ?>" class="masonry__item__wrapper">
                                        <div class="masonry__item__image">
                                            <?php
                                                $imageVar = $item['bg'];
                                                $imageClass = 'masonry__item__image__bg';
                                                include( locate_template( 'partials/image-srcset.php', false, false ) );
                                            ?>
                                            <?php if($item['gradient']) : ?>
                                                <div class="masonry__item__gradient"></div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="masonry__item__content">
                                            <div class="masonry__item__category"><?= $item['categories'][0]->name; ?></div>
                                            <div class="masonry__item__title"><?= $item['title']; ?></div>
                                        </div>
                                    </a>
                                <?php endif; ?>
                                
                                <?php if($item['categories'][0]->slug === 'research-case-studies') : ?>
                                    <a href="<?= $item['url']; ?>" class="masonry__item__wrapper">
                                        <div class="masonry__item__image">
                                            <img src="<?= $item['logo']['url']; ?>" width="100" height="100" alt="<?= $item['title']; ?>" class="masonry__item__image__bg">
                                        </div>
                                        <div class="masonry__item__content">
                                            <div class="masonry__item__category"><?= $item['categories'][0]->name; ?></div>
                                            <div class="masonry__item__title"><?= $item['title']; ?></div>
                                        </div>
                                    </a>
                                <?php endif; ?>
                                
                                <?php if($item['categories'][0]->slug === 'testimonials') : ?>
                                    <div class="masonry__item__wrapper masonry__item__wrapper--quote">
                                        <div class="masonry__item__icon" style="background-image: url(<?= $item['categories_icon']['url']; ?>)"></div>
                                        <div class="masonry__item__quote"><?= $item['quote']; ?></div>
                                        <div class="masonry__item__author"><?= $item['author']; ?></div>
                                    </div>
                                <?php endif; ?>                            
                            </div>
                        <?php endforeach; ?>
                        <div class="masonry__item-size"></div>
                    </section>
                <?php endif; ?>
            </knowledge-centre-list>
        </div>

    </div>
</section>