<?php
    $heading = get_field('accordion_heading');
    $accordion = get_field('accordion');
?>
<section class="home-accordion">
    <div class="home-accordion__container container">
        <h2 class="home-accordion__heading home-accordion__heading--mobile"><?php echo $heading; ?></h2>
        <div class="home-accordion__images">
            <?php foreach ( $accordion as $index=>$item ) : 
                $imageVar = $item['image'];
                $imageClass = 'home-accordion__image';
                if($index === 0) {
                    $pictureClass = 'is-active';
                } else {
                    $pictureClass = '';
                }
                include( locate_template( 'partials/image-srcset.php', false, false ) );
            endforeach; ?>
        </div>
        <div class="home-accordion__wrapper">
            <h2 class="home-accordion__heading"><?php echo $heading; ?></h2>
            <div class="home-accordion__accordion">
                <?php foreach ( $accordion as $index=>$item ) : ?>
                    <div class="home-accordion__content <?php echo ( $index === 0 ) ? 'is-active' : null; ?>">
                        <div class="home-accordion__content__title" data-index="<?php echo $index; ?>">
                            <?php echo $item['title']; ?>
                        </div>
                        <div class="home-accordion__content__text">
                            <?php echo $item['content']; ?>
                            <div class="home-accordion__content__btn">
                                <?php
                                    $btnVar = $item;
                                    include( locate_template( 'partials/button.php', false, false ) );
                                ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>