<?php
    $heading = get_sub_field('heading');
    $tables = get_sub_field('tables');
    $btn = get_sub_field('button');
?>
<section class="fp-table">
    <div class="container">
        <?php if ( $heading ) : ?>
            <div class="fp-table__heading">
                <h2><?php echo $heading; ?></h2>
            </div>
        <?php endif; ?>
        <div class="fp-table__table">

            <?php foreach ( $tables as $table ): ?>
                <?php
                    $wide = ( $table['table_wide'] ) ? 'table-wide' : null;
                    $table = $table['table'];
                ?>
                    <div class="fp-table__table__wrapper <?php echo $wide; ?>">
                    <?php
                        if ( ! empty ( $table ) ) {

                            echo "<table border='0' class='". $wide ."'>";

                            if ( ! empty( $table['caption'] ) ) {

                                echo '<caption>' . $table['caption'] . '</caption>';
                            }

                            if ( ! empty( $table['header'] ) ) {

                                echo '<thead>';

                                echo '<tr>';

                                foreach ( $table['header'] as $th ) {

                                    echo '<th>';
                                    echo $th['c'];
                                    echo '</th>';
                                }

                                echo '</tr>';

                                echo '</thead>';
                            }

                            echo '<tbody>';

                            foreach ( $table['body'] as $tr ) {

                                echo '<tr>';

                                foreach ( $tr as $td ) {

                                    $rowHeading = ( $td['c'] === 'row' ) ? 'class="row-heading"' : null;

                                    echo "<td ". $rowHeading . ">";
                                    echo $td['c'];
                                    echo '</td>';
                                }

                                echo '</tr>';
                            }

                            echo '</tbody>';

                            echo '</table>';
                        }
                    ?>
                    </div>
            <?php endforeach; ?>
        </div>
        <div class="fp-table__btn">
            <?php
                $btnVar = $btn;
                include( locate_template( 'partials/button.php', false, false ) );
            ?>
        </div>
    </div>
</section>