<section class="related-featured-products">
    <div class="related-featured-products__container container">
        <?php
            $productID = $post->ID;

            $args = array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'post_parent'    => $post->post_parent,
                'child_of'       => $post->post_parent,
                'order'          => 'ASC',
                'orderby'        => 'menu_order'
            );

            $parent = new WP_Query( $args );

            if ( $parent->have_posts() ) :
        ?>
            <?php while ( $parent->have_posts() ) : $parent->the_post(); ?>
                <?php
                    $icon = get_field('icon_product');
                    $iconWhite = get_field('icon_product_white');
                ?>
                <div class="related-featured-products__btn">
                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="btn btn-product <?php echo ( $productID === $post->ID ) ? 'is-active' : null; ?>">
                        <div class="btn-product__icon-wrapper">
                            <i class="btn-product__icon" style="background-image: url('<?php echo $icon['url']; ?>');"></i>
                            <i class="btn-product__icon btn-product__icon--white" style="background-image: url('<?php echo $iconWhite['url']; ?>');"></i>
                        </div>
                        <?php the_title(); ?>
                    </a>
                </div>
            <?php endwhile; ?>
        <?php endif; wp_reset_query(); ?>
    </div>
</section>