<?php
    $heading = get_sub_field('heading');
    $image = get_sub_field('image');
    $maxWith = get_sub_field('max_with_image');
    $caption = get_sub_field('caption');
?>
<section class="fp-image">
    <div class="container">
        <?php if ( $heading ) : ?>
            <div class="fp-image__heading">
                <h2><?php echo $heading; ?></h2>
            </div>
        <?php endif; ?>
        <div class="fp-image__image" <?php echo ( $maxWith ) ? 'style="max-width: '. $maxWith .'px;"' : null; ?>>
            <?php
                $imageVar = $image;
                $imageClass = '';
                include( locate_template( 'partials/image-srcset.php', false, false ) );
            ?>
            <?php if ( $caption ) : ?>
            <div class="fp-image__caption">
                <p><?php echo $caption; ?></p>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>