<?php
    $heading = get_sub_field('heading');
    $files = get_sub_field('files');
?>
<section class="fp-downloads">
    <div class="container">
        <?php if ( $heading ) : ?>
            <div class="fp-downloads__heading">
                <h2><?php echo $heading; ?></h2>
            </div>
        <?php endif; ?>
        <div class="fp-downloads__files row">
            <?php foreach ( $files as $file ) : ?>
                <div class="fp-downloads__file col">
                    <a class="fp-downloads__file__wrapper" href="<?php echo $file['file']['url']; ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" width="73.362" height="80.598" viewBox="0 0 73.362 80.598">
                            <g id="file-icon" transform="translate(-11.5 -9.5)">
                                <path id="Path_2208" data-name="Path 2208" d="M24,57.035,38.472,73.317,52.945,57.035M38.472,10V73.317" transform="translate(9.709)" fill="none" stroke="#494949" stroke-linecap="round" stroke-linejoin="round" stroke-width="1"/>
                                <path id="Path_2209" data-name="Path 2209" d="M12,54H84.362" transform="translate(0 35.598)" fill="none" stroke="#494949" stroke-linecap="round" stroke-linejoin="round" stroke-width="1"/>
                            </g>
                        </svg>
                        <?php echo $file['label']; ?>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>