<?php
    $bg = get_sub_field('background_image');
    $logo = get_sub_field('logo')['url'];
?>
<section class="fp-custom-section-logo-col-boxes">
    <div class="container container--fluid">
        <div class="fp-custom-section-logo-col-boxes__bg">
            <?php
                $imageVar = $bg;
                $imageClass = '';
                include( locate_template( 'partials/image-srcset.php', false, false ) );
            ?>
        </div>
        <div class="fp-custom-section-logo-col-boxes__container container">
            <div class="fp-custom-section-logo-col-boxes__logo">
                <img width="100" height="100" src="<?php echo $logo; ?>" alt="">
            </div>

            <div class="fp-custom-section-logo-col-boxes__column">
                <?php
                    $column = get_sub_field('column');
                ?>
                <div class="fxsc-content">
                    <h3><?php echo $column['heading']; ?></h3>
                    <?php foreach ( $column['buttons'] as $btn ) : ?>
                        <div>
                            <?php
                                $btnVar = $btn;
                                include( locate_template( 'partials/button.php', false, false ) );
                            ?>
                        </div>
                    <?php endforeach; ?>
                </div>
                <?php
                    $columnRight = get_sub_field('column_right');
                ?>
                <div class="fxsc-content">
                    <?php echo $columnRight['content']; ?>
                </div>
            </div>
            <?php
                $heading = get_sub_field('heading');
            ?>
            <?php if ( $heading ) : ?>
            <div class="fp-boxes-of-text__heading">
                <?php echo $heading; ?>
            </div>
            <?php endif; ?>
            <div class="fp-boxes-of-text__boxes row">
                <?php
                    $boxes = get_sub_field('boxes_of_text');
                ?>
                <?php foreach ( $boxes as $box ) : ?>
                    <div class="fp-boxes-of-text__box col">
                        <div class="fp-boxes-of-text__box__wrapper">
                            <?php echo $box['text']; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>