<?php
    $heading = get_sub_field('heading');
    $boxes = get_sub_field('boxes');
?>
<section class="fx-see-also">
    <div class="fx-see-also__container container">
        <h2 class="fx-see-also__heading">
            <?php echo $heading; ?>
        </h2>
        <div class="fx-see-also__boxes row">
            <?php foreach ( $boxes as $box ) : ?>
                <div class="col">
                    <a href="<?php echo $box['url']; ?>" title="<?php echo $box['title']; ?>" class="fx-see-also__box">
                        <?php
                            $imageVar = $box['background_image'];
                            $imageClass = 'fx-see-also__box__bg';
                            include( locate_template( 'partials/image-srcset.php', false, false ) );
                        ?>
                        <div class="fx-see-also__box__title"><?php echo $box['title']; ?></div>
                        <div class="fx-see-also__box__btn btn btn--more">Learn more</div>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>