<?php
    $position = get_sub_field('image_position');
    $image = get_sub_field('image');
    $imageWidth = get_sub_field('image_width');
    $minWith = $imageWidth['min'];
    $maxWith = $imageWidth['max'];
    $title = get_sub_field('title');
    $heading = get_sub_field('heading');
    $content = get_sub_field('content');
?>
<section class="fx-company-content-and-image <?php echo ( $position ) ? 'fx-company-content-and-image--reversed' : null; ?>">
    <div class="fx-company-content-and-image__container container">
        <div class="fx-company-content-and-image__content">
            <h2 class="fx-company-content-and-image__title">
                <?php echo $title; ?>
                <?php if ( $heading ) : ?>
                    <span><?php echo $heading; ?></span>
                <?php endif; ?>
            </h2>
            <?php echo $content; ?>
        </div>
        <div class="fx-company-content-and-image__image">
            <div style="<?php echo ( $maxWith ) ? 'max-width: '. $maxWith .'px;' : ''; ?> <?php echo ( $minWith ) ? 'min-width: '. $minWith .'px;' : ''; ?>">
                <?php
                    $imageVar = $image;
                    $imageClass = '';
                    include( locate_template( 'partials/image-srcset.php', false, false ) );
                ?>
            </div>
        </div>
    </div>
</section>