<?php 
    $img_position = (get_sub_field('image_position')) ? 'flex-image-content--left' : 'flex-image-content--right';
    $image_holder_class = (get_sub_field('space_remover')) ? ' flex-image-content--no-space' : '';
    $title = get_sub_field('title');
    $image = get_sub_field('image');
    $content = get_sub_field('content');
?>
<div class="flex-image-content <?php echo $img_position.$image_holder_class; ?>">
    <div class="flex-image-content__image">
        <picture>
            <?php if ( $image['mime_type'] != 'image/svg+xml' ) : ?>
            <source
                type="image/webp"
                srcset="<?php echo $image['sizes']['placeholder']; ?>.webp"
                data-srcset="<?php echo $image['url']; ?>.webp 1440w,
                <?php echo $image['sizes']['largeRetina']; ?>.webp 1024w,
                <?php echo $image['sizes']['largeRetina']; ?>.webp 600w,
                <?php echo $image['sizes']['medium_large']; ?>.webp 320w">
            <source
                type="<?php echo $image['mime_type']; ?>"
                srcset="<?php echo $image['sizes']['placeholder']; ?>"
                data-srcset="<?php echo $image['url']; ?> 1440w,
                <?php echo $image['sizes']['largeRetina']; ?> 1024w,
                <?php echo $image['sizes']['largeRetina']; ?> 600w,
                <?php echo $image['sizes']['medium_large']; ?> 320w" >
                <img class="lazyload blur-up <?php echo $imageClass; ?>" width="400" height="300" data-expand="-50" src="<?php echo $image['sizes']['placeholder']; ?>" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
            <?php else : ?>
                <img class="lazyload blur-up <?php echo $imageClass; ?>" width="400" height="300" data-expand="-50" src="<?php echo $image['url']; ?>" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
            <?php endif; ?>
        </picture>
    </div>
    
    <div class="flex-image-content__text">
        <?php if($title) : ?>
            <h2><?php echo $title; ?></h2>
        <?php endif; ?>
        <div class="flex-image-content__text__content content">
            <?php echo $content; ?>
        </div>
    </div>
</div>