<?php
    $banner = get_field('top_banner');
    $background = $banner['background_image'];
    $icon = $banner['icon']['url'];
    $content = $banner['content'];
    $heading = $banner['heading_small'];
    $title = $banner['title'];
?>
<section class="top-banner top-banner--solutions">
    <?php
        $imageVar = $background;
        $imageClass = 'top-banner__bg';
        include( locate_template( 'partials/image-srcset.php', false, false ) );
    ?>
    <div class="top-banner__container container">
        <div class="top-banner__content">
            <?php if ( $icon ) : ?>
                <img class="top-banner__icon" width="400" height="300" src="<?php echo $icon; ?>" alt="<?php the_title(); ?>">
            <?php endif; ?>
            <?php if ($heading) : ?>
                <h6><?php echo $heading; ?></h6>
            <?php endif; ?>
            <h1><?php echo $title; ?></h1>
            <div class="top-banner__content">
                <?php echo $content; ?>
            </div>
        </div>
    </div>
</section>