<?php
    // Clone component
    $banner = get_field('top_banner')['top_banner'];
    $background = $banner['background_image'];
    $content = $banner['content'];
?>
<section class="top-banner top-banner--about">
    <picture>
        <?php if ( $background['mime_type'] != 'image/svg+xml' ) : ?>
            <source
                    type="image/webp"
                    srcset="<?php echo $background['sizes']['large']; ?>.webp"
                    data-srcset="<?php echo $background['url']; ?>.webp 1920w,
                     <?php echo $background['sizes']['largeRetina']; ?>.webp 1440w,
                     <?php echo $background['sizes']['largeRetina']; ?>.webp 1024w,
                     <?php echo $background['sizes']['medium_large']; ?>.webp 600w,
                     <?php echo $background['sizes']['medium_large']; ?>.webp 320w">
            <source
                    type="<?php echo $background['mime_type']; ?>"
                    srcset="<?php echo $background['sizes']['large']; ?>"
                    data-srcset="<?php echo $background['url']; ?> 1920w,
                     <?php echo $background['sizes']['largeRetina']; ?> 1440w,
                     <?php echo $background['sizes']['largeRetina']; ?> 1024w,
                     <?php echo $background['sizes']['medium_large']; ?> 600w,
                     <?php echo $background['sizes']['medium_large']; ?> 320w" >
            <img class="lazyload blur-up top-banner__bg" width="400" height="300" data-expand="-50" src="<?php echo $background['sizes']['placeholder']; ?>" data-src="<?php echo $background['url']; ?>" alt="<?php echo $background['alt']; ?>">
        <?php else : ?>
            <img class="lazyload blur-up top-banner__bg" width="400" height="300" data-expand="-50" src="<?php echo $background['url']; ?>" data-src="<?php echo $background['url']; ?>" alt="<?php echo $background['alt']; ?>">
        <?php endif; ?>
    </picture>
    <div class="top-banner__container container">
        <div class="top-banner__content">
            <div class="top-banner__breadcrumbs"><?php the_title(); ?></div>
            <?php echo $content; ?>
            <?php
                $btnVar = get_field('button');
                include( locate_template( 'partials/button.php', false, false ) );
            ?>
        </div>
    </div>
</section>