<?php
    $box = get_field('box');
    $code = get_field('product_code');
    $sizes = get_field('product_sizes', false, false);
    $image = $box['image'];
    $excerpt = ( $box['excerpt'] ) ? $box['excerpt'] : wp_trim_words(get_field('product_description'), $num_words = 20, $more = '...');
?>
<a href="<?php the_permalink(); ?>"
   title="View"
   class="box-product__wrapper">
    <div class="box-product__image">
        <?php
            $imageVar = $image;
            $imageClass = '';
            include( locate_template( 'partials/image-srcset.php', false, false ) );
        ?>
    </div>
    <h4 class="box-product__title">
        <?php the_title(); ?>
        <?php if ( $code ): ?>
            / <?php echo $code; ?>
        <?php endif; ?>
    </h4>
    <div class="box-product__excerpt">
        <?php echo $excerpt ?>
    </div>

    <div class="box-product__sizes">
        <?php if ( $sizes ) : ?>
            <strong>Dimensions:</strong><br>
            <?php echo $sizes; ?>
        <?php endif; ?>
    </div>
    <div class="box-product__btn btn btn btn--view">View</div>
</a>