<?php
    $image = $imageVar;

    if ( $image ) :
?>
<?php if ( $image['mime_type'] != 'image/svg+xml' ) : ?>
<link rel="preload" as="image" 
        imagesrcset="<?php echo $image['url']; ?>.webp 1920w,
        <?php echo $image['sizes']['largeRetina']; ?>.webp 1440w,
        <?php echo $image['sizes']['large']; ?>.webp 1024w,
        <?php echo $image['sizes']['medium_large']; ?>.webp 600w,
        <?php echo $image['sizes']['medium']; ?>.webp 320w" 
        imagesizes="100vw">
<?php endif; ?>   
<picture>
    <?php if ( $image['mime_type'] != 'image/svg+xml' ) : ?>
    <source
        type="image/webp"
        srcset="<?php echo $image['url']; ?>.webp 1920w,
         <?php echo $image['sizes']['largeRetina']; ?>.webp 1440w,
         <?php echo $image['sizes']['large']; ?>.webp 1024w,
         <?php echo $image['sizes']['medium_large']; ?>.webp 600w,
         <?php echo $image['sizes']['medium']; ?>.webp 320w">
    <source
        type="<?php echo $image['mime_type']; ?>"
        srcset="<?php echo $image['url']; ?> 1920w,
         <?php echo $image['sizes']['largeRetina']; ?> 1440w,
         <?php echo $image['sizes']['large']; ?> 1024w,
         <?php echo $image['sizes']['medium_large']; ?> 600w,
         <?php echo $image['sizes']['medium']; ?> 320w" >
        <img class="<?php echo $imageClass; ?>" width="400" height="300" src="<?php echo $image['sizes']['placeholder']; ?>" alt="<?php echo $image['alt']; ?>">
    <?php else : ?>
        <img class="<?php echo $imageClass; ?>" width="400" height="300" src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
    <?php endif; ?>
</picture>
<?php endif; ?>