<?php
    $image = $imageVar;

    if ( $image ) :
?>
<picture class="<?php echo $pictureClass; ?>">
    <?php if ( $image['mime_type'] != 'image/svg+xml' ) : ?>
    <source
        type="image/webp"
        srcset="<?php echo $image['sizes']['placeholder']; ?>.webp"
        data-srcset="<?php echo $image['url']; ?>.webp 1920w,
         <?php echo $image['sizes']['largeRetina']; ?>.webp 1440w,
         <?php echo $image['sizes']['large']; ?>.webp 1024w,
         <?php echo $image['sizes']['medium_large']; ?>.webp 600w,
         <?php echo $image['sizes']['medium']; ?>.webp 320w">
    <source
        type="<?php echo $image['mime_type']; ?>"
        srcset="<?php echo $image['sizes']['placeholder']; ?>"
        data-srcset="<?php echo $image['url']; ?> 1920w,
         <?php echo $image['sizes']['largeRetina']; ?> 1440w,
         <?php echo $image['sizes']['large']; ?> 1024w,
         <?php echo $image['sizes']['medium_large']; ?> 600w,
         <?php echo $image['sizes']['medium']; ?> 320w" >
        <img class="lazyload blur-up <?php echo $imageClass; ?>" width="400" height="300" data-expand="-50" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
    <?php else : ?>
        <img class="lazyload blur-up <?php echo $imageClass; ?>" width="400" height="300" data-expand="-50" data-src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
    <?php endif; ?>
</picture>
<?php endif; ?>