<?php
    $desktop_image = $desktop_bg;
    $mobile_image = $mobile_bg;

    if ( $desktop_image || $mobile_image ) :
?>
<picture class="<?php echo $pictureClass; ?>">
    <?php if ( $desktop_image['mime_type'] != 'image/svg+xml' ) : ?>
    <source
        type="image/webp"
        srcset="<?php echo $mobile_image['sizes']['medium_large']; ?>.webp 768w,
        <?php echo $desktop_image['sizes']['large']; ?>.webp 1024w,
        <?php echo $desktop_image['sizes']['largeRetina']; ?>.webp 1440w,
        <?php echo $desktop_image['url']; ?>.webp 1920w"
         sizes="(max-width: 767px) 768px,
                (min-width: 768px) and (max-width: 1023px) 1024px,
                (min-width: 1024px) and (max-width: 1439px) 1440px,
                (min-width: 1440px) 1920px,
                768px" >
    <source
        type="<?php echo $desktop_image['mime_type']; ?>"
        srcset="<?php echo $mobile_image['sizes']['medium_large']; ?> 768w,
        <?php echo $desktop_image['sizes']['large']; ?> 1024w,
        <?php echo $desktop_image['sizes']['largeRetina']; ?> 1440w,
        <?php echo $desktop_image['url']; ?> 1920w"
         sizes="(max-width: 767px) 768px,
                (min-width: 768px) and (max-width: 1023px) 1024px,
                (min-width: 1024px) and (max-width: 1439px) 1440px,
                (min-width: 1440px) 1920px,
                576px"  >
        <img class="<?php echo $imageClass; ?>" width="400" height="300" src="<?php echo $mobile_image['sizes']['medium']; ?>" alt="<?php echo $desktop_image['alt']; ?>">
    <?php else : ?>
        <img class="<?php echo $imageClass; ?>" width="400" height="300" src="<?php echo $desktop_image['url']; ?>" alt="<?php echo $desktop_image['alt']; ?>">
    <?php endif; ?>
</picture>
<?php endif; ?>