<?php
    /* code PHP
        $btnVar = $btn;
        include( locate_template( 'partials/button.php', false, false ) );
    */

    $btn = $btnVar['button'];
    $target = ($btn['open_the_link'] === '_blank') ? 'target="_blank" rel="noopener noreferrer"' : null;
    $style = $btn['style'];
    $label = $btn['text'];

    // Create url
    if ( $btn['direction'] == 'internal' ) {
        $url = $btn['page_link'];
    } elseif ( $btn['direction'] == 'external' ) {
        $url = $btn['page_link-external'];
    } elseif ( $btn['direction'] == 'email' ) {
        $url = 'mailto:'.$btn['email_link'];
    } elseif ( $btn['direction'] == 'tel' ) {
        $url = 'tel:'.$btn['tel_link'];
    }
?>

<?php if($url && $label) : ?>
    <?php if ( $btnRep ) : ?>
        <div class="btn__single">
            <a class="btn <?php echo $style; ?>" href="<?php echo $url; ?>" <?php echo $target; ?>>
                <?php echo $label; ?>
            </a>
        </div>
    <?php else : ?>
        <a class="btn <?php echo $style; ?>" href="<?php echo $url; ?>" <?php echo $target; ?>>
            <?php echo $label; ?>
        </a>
    <?php endif; ?>
<?php elseif ( $style === 'btn--video' ) : ?>
    <?php
        $video = $btn['video'];
    ?>
    <div class="btn <?php echo $style; ?>">
        <?php echo $label; ?>
    </div>
    <?php if ( $video ) : ?>
        <div class="popup-video">
            <div class="popup-video__close"></div>
            <video preload="none" playsinline loop>
                <source src="<?php echo $video; ?>" type="video/mp4" />
            </video>
        </div>
    <?php endif; ?>
<?php endif; ?>