<!DOCTYPE html>
<html <?php language_attributes(); ?>>

    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

        <title><?php wp_title( ' | ', TRUE, 'right' ); ?></title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>

        <style>
            /* Critical Path CSS Generated by Pegasaas Accelerator at https://pegasaas.com/ for https://gvhealth.com/ viewport Mobile - 375px */ 
            @font-face{font-family: 'Exo';font-style: normal;font-weight: 300;font-display: swap;src: url(https://fonts.gstatic.com/s/exo/v15/4UaZrEtFpBI4f1ZSIK9d4LjJ4g03CwM.ttf) format('truetype')}@font-face{font-family: 'Exo';font-style: normal;font-weight: 400;font-display: swap;src: url(https://fonts.gstatic.com/s/exo/v15/4UaZrEtFpBI4f1ZSIK9d4LjJ4lM3CwM.ttf) format('truetype')}@font-face{font-family: 'Exo';font-style: normal;font-weight: 500;font-display: swap;src: url(https://fonts.gstatic.com/s/exo/v15/4UaZrEtFpBI4f1ZSIK9d4LjJ4mE3CwM.ttf) format('truetype')}@font-face{font-family: 'Exo';font-style: normal;font-weight: 600;font-display: swap;src: url(https://fonts.gstatic.com/s/exo/v15/4UaZrEtFpBI4f1ZSIK9d4LjJ4o0wCwM.ttf) format('truetype')}@font-face{font-family: 'Exo';font-style: normal;font-weight: 700;font-display: swap;src: url(https://fonts.gstatic.com/s/exo/v15/4UaZrEtFpBI4f1ZSIK9d4LjJ4rQwCwM.ttf) format('truetype')}:root{--swiper-theme-color: #007aff}.swiper-container{margin-left: auto;margin-right: auto;position: relative;overflow: hidden;list-style: none;padding: 0;z-index: 1}.swiper-wrapper{position: relative;width: 100%;height: 100%;z-index: 1;display: flex;box-sizing: content-box}.swiper-wrapper{transform: translateZ(0)}.swiper-slide{flex-shrink: 0;width: 100%;height: 100%;position: relative}body,div,h2,header,html,i,iframe,img,nav,p,section,span,strong,video{margin: 0;padding: 0;border: 0;outline: 0;font-size: 100%;vertical-align: baseline;background: transparent}body{line-height: 1}header,nav,section{display: block}a{margin: 0;padding: 0;font-size: 100%;vertical-align: baseline;background: transparent}html{line-height: 1.15;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%}body{margin: 0}header,nav,section{display: block}main{display: block}a{background-color: transparent;-webkit-text-decoration-skip: objects}strong{font-weight: inherit;font-weight: bolder}video{display: inline-block}img{border-style: none}::-webkit-file-upload-button{-webkit-appearance: button;font: inherit}img{display: block;width: 100%;height: auto}.blur-up{opacity: .2;will-change: opacity}.home-carousel .blur-up{opacity: .1}.container{margin-right: auto;margin-left: auto;padding-left: 30px;padding-right: 30px;max-width: 1920px;width: 100%}.container--fluid{padding-left: 30px;padding-right: 30px}.btn{display: inline-block;text-decoration: none}.btn+.btn{margin-left: 7px}.btn--border-blue{font-size: 1.3rem;line-height: 1;font-weight: 400;border-radius: 25px;border: 1px solid #0d95ce;padding: 18px 39px;background-color: #fff}.home .main-header .btn--border-blue{padding: 18px 34px}.home .main-header:not(.nav-up):not(.is-top):not(.menu-active) .btn--border-blue{font-size: 1.3rem;line-height: 1;font-weight: 400;color: #fff;border-radius: 25px;padding: 18px 34px;background-color: hsla(0,0%,100%,.25);border: 1px solid hsla(0,0%,100%,0)}.btn--blue{font-size: 1.3rem;line-height: 1;font-weight: 400;color: #fff;border-radius: 25px;padding: 18px 39px;background-color: #0d95ce;border: 1px solid #0d95ce}.home .main-header .btn--blue{padding: 18px 34px}.home .main-header:not(.nav-up):not(.is-top):not(.menu-active) .btn--blue{font-size: 1.3rem;line-height: 1;color: #000;font-weight: 400;border-radius: 25px;padding: 18px 34px;background-color: #fff;border: 1px solid hsla(0,0%,100%,0)}.btn--white{font-size: 1.3rem;line-height: 1;font-weight: 400}.btn--white{color: #000;border-radius: 25px;padding: 16px 34px;background-color: #fff;border: 1px solid #fff}.btn--more{font-weight: 400}.btn--more:after{display: inline-block;content: "";margin-left: 15px;height: 14px;width: 14px;background-image: url(https://gvhealth.com/wp-content/themes/gvhealthTheme/public/images/icon-plus.svg);background-repeat: no-repeat;background-position: 50%;-webkit-background-size: contain;background-size: contain}.btn--arrow-blue{position: relative;font-size: 1.3rem;font-weight: 400;color: #0d95ce;padding-right: 20px}.btn--arrow-blue:after{display: inline-block;content: "";position: absolute;top: 50%;right: 0;-moz-transform: rotate(-90deg) translate(40%);-o-transform: rotate(-90deg) translate(40%);-ms-transform: rotate(-90deg) translate(40%);-webkit-transform: rotate(-90deg) translate(40%);transform: rotate(-90deg) translate(40%);width: 10px;height: 6px;background-image: url(https://gvhealth.com/wp-content/themes/gvhealthTheme/public/images/icon-arrow-menu.svg);background-repeat: no-repeat;background-position: 50%;-webkit-background-size: contain;background-size: contain;will-change: transform}.btn--text-blue{position: relative;font-size: 1.4rem;font-weight: 400;color: #0d95ce;padding-right: 20px}.btn--text-blue:after{display: inline-block;content: "";position: absolute;top: 50%;right: 0;-moz-transform: rotate(-90deg) translate(30%);-o-transform: rotate(-90deg) translate(30%);-ms-transform: rotate(-90deg) translate(30%);-webkit-transform: rotate(-90deg) translate(30%);transform: rotate(-90deg) translate(30%);width: 10px;height: 6px;background-image: url(https://gvhealth.com/wp-content/themes/gvhealthTheme/public/images/icon-arrow-menu.svg);background-repeat: no-repeat;background-position: 50%;-webkit-background-size: contain;background-size: contain;will-change: transform}.btn-product{border-radius: 10px;line-height: 1;font-size: 1.3rem;font-weight: 300;color: #000;background-color: #fff;width: 150px;height: 55px;display: -webkit-box;display: -moz-box;display: -ms-flexbox;display: -webkit-flex;display: flex;-webkit-align-items: center;-moz-align-items: center;-ms-align-items: center;align-items: center;-webkit-justify-content: center;-moz-justify-content: center;-ms-justify-content: center;justify-content: center;-ms-flex-pack: center}.btn-product+.btn-product{margin-left: 0}.btn-product__icon-wrapper{position: relative}.btn-product__icon{display: inline-block;margin-right: 10px;height: 28px;width: 25px;background-repeat: no-repeat;background-position: 50%;-webkit-background-size: contain;background-size: contain}.btn-product__icon--white{position: absolute;top: 0;left: 0;opacity: 0}.main-menu .btn-product{color: #fff;background: linear-gradient(90deg,#0d95ce,#54b7d3)}.main-menu .btn-product .btn-product__icon{opacity: 0}.main-menu .btn-product .btn-product__icon--white{opacity: 1}body,html{width: 100%}*{-webkit-box-sizing: border-box;-moz-box-sizing: border-box;box-sizing: border-box}html{font-size: 62.5%;-webkit-font-smoothing: antialiased;-moz-osx-font-smoothing: grayscale}body{font-family: Exo,sans-serif;font-weight: 300;line-height: 1.75;color: #494949;margin-top: 80px;font-size: 14px}body.home{margin-top: 0}h2{font-family: Exo,sans-serif}h2{font-weight: 300;color: inherit;margin: 0;padding: 0}h2{font-size: 24px}a{color: inherit;text-decoration: none}strong{font-weight: 700}.main-header{position: fixed;z-index: 101;top: 0;padding: 12px 0;width: 100%;background-color: #fff;-webkit-box-shadow: 0 0 24px rgba(0,0,0,.08);-moz-box-shadow: 0 0 24px rgba(0,0,0,.08);box-shadow: 0 0 24px rgba(0,0,0,.08);will-change: background-color;will-change: transform;-moz-transform: translate(0);-o-transform: translate(0);-ms-transform: translate(0);-webkit-transform: translate(0);transform: translate(0)}.home .main-header{background-color: transparent;-webkit-box-shadow: 0 0 0 rgba(0,0,0,.08);-moz-box-shadow: 0 0 0 rgba(0,0,0,.08);box-shadow: 0 0 0 rgba(0,0,0,.08)}.main-header__container{display: -webkit-box;display: -moz-box;display: -ms-flexbox;display: -webkit-flex;display: flex;-webkit-align-items: center;-moz-align-items: center;-ms-align-items: center;align-items: center;-webkit-justify-content: space-between;-moz-justify-content: space-between;-ms-justify-content: space-between;justify-content: space-between;-ms-flex-pack: space-between}.main-header__logo{position: relative;width: 140px}.main-header__logo img{display: block;width: 100%;height: auto;opacity: 1;will-change: opacity}.home .main-header__logo img:last-child{position: absolute;top: 0;left: 0;opacity: 0}.main-header__nav{display: none;font-size: 1.3rem;font-weight: 400}.main-header__nav__link{margin-right: 40px}.home .main-header__nav__link{color: #fff}.main-header__nav__link:after{display: inline-block;content: "";position: relative;top: -2px;margin-left: 10px;width: 10px;height: 6px;background-image: url(https://gvhealth.com/wp-content/themes/gvhealthTheme/public/images/icon-arrow-menu.svg);background-repeat: no-repeat;background-position: 50%;-webkit-background-size: contain;background-size: contain;will-change: transform}.home .main-header__nav__link:after{background-image: url(https://gvhealth.com/wp-content/themes/gvhealthTheme/public/images/icon-arrow-menu--white.svg)}.main-header__nav__link+.btn{margin-left: 20px}.main-header__btn{display: block}.main-header__btn__line{display: block;width: 20px;height: 2px;margin-bottom: 5px;position: relative;background: #494949;z-index: 1;transform-origin: 4px 0}.home .main-header__btn__line{background-color: #fff}.main-header__btn__line:first-child{transform-origin: 0 0}.main-header__btn__line:last-child{transform-origin: 0 100%}.main-menu{position: fixed;top: 0;left: 0;z-index: 90;background-color: #f7f7f7;-webkit-box-shadow: 0 0 24px rgba(0,0,0,.08);-moz-box-shadow: 0 0 24px rgba(0,0,0,.08);box-shadow: 0 0 24px rgba(0,0,0,.08);padding-top: 110px;padding-bottom: 30px;width: 100%;height: 100vh;-moz-transform: translate(100%);-o-transform: translate(100%);-ms-transform: translate(100%);-webkit-transform: translate(100%);transform: translate(100%);will-change: transform}.main-menu__nav{display: -webkit-box;display: -moz-box;display: -ms-flexbox;display: -webkit-flex;display: flex;-webkit-flex-direction: column;-moz-flex-direction: column;-ms-flex-direction: column;flex-direction: column;-webkit-flex-flow: wrap;-moz-flex-flow: wrap;-ms-flex-flow: wrap;flex-flow: wrap;border-top: 1px solid rgba(13,149,206,.5)}.main-menu__nav__link{position: relative;color: #494949;font-size: 1.6rem;padding: 10px 0;width: 100%;border-bottom: 1px solid rgba(13,149,206,.5)}.main-menu__nav__link:after{display: inline-block;content: "";position: absolute;top: 50%;right: 15px;margin-left: 10px;margin-top: -3px;width: 10px;height: 6px;background-image: url(https://gvhealth.com/wp-content/themes/gvhealthTheme/public/images/icon-arrow-menu.svg);background-repeat: no-repeat;background-position: 50%;-webkit-background-size: contain;background-size: contain;-moz-transform: rotate(-90deg);-o-transform: rotate(-90deg);-ms-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);transform: rotate(-90deg)}.main-menu__nav a.btn{margin-top: 20px;width: calc(50% - 10px);text-align: center}.main-menu__nav a.btn+.btn{margin-left: 20px}.main-menu__container{position: absolute;overflow: auto;z-index: 2;top: 0;left: 0;display: -webkit-box;display: -moz-box;display: -ms-flexbox;display: -webkit-flex;display: flex;-webkit-flex-direction: column;-moz-flex-direction: column;-ms-flex-direction: column;flex-direction: column;-webkit-align-items: flex-start;-moz-align-items: flex-start;-ms-align-items: flex-start;align-items: flex-start;-webkit-flex-flow: column;-moz-flex-flow: column;-ms-flex-flow: column;flex-flow: column;background-color: #f7f7f7;-moz-transform: translate(100%);-o-transform: translate(100%);-ms-transform: translate(100%);-webkit-transform: translate(100%);transform: translate(100%);will-change: opacity,transform;padding-top: 110px;padding-bottom: 30px}.main-menu__left{width: 100%;display: -webkit-box;display: -moz-box;display: -ms-flexbox;display: -webkit-flex;display: flex;-webkit-flex-direction: column;-moz-flex-direction: column;-ms-flex-direction: column;flex-direction: column;-webkit-flex-flow: wrap;-moz-flex-flow: wrap;-ms-flex-flow: wrap;flex-flow: wrap}.main-menu__left--knowledge-centre{width: 100%}.main-menu__left--company{width: 100%}.main-menu__right{position: relative;margin-top: 20px;width: 100%;display: -webkit-box;display: -moz-box;display: -ms-flexbox;display: -webkit-flex;display: flex;-webkit-flex-direction: column;-moz-flex-direction: column;-ms-flex-direction: column;flex-direction: column;-webkit-flex-flow: wrap;-moz-flex-flow: wrap;-ms-flex-flow: wrap;flex-flow: wrap}.main-menu__container--solutions .main-menu__right{display: none}.main-menu__right--featured{width: 100%;-webkit-align-items: flex-start;-moz-align-items: flex-start;-ms-align-items: flex-start;align-items: flex-start}.main-menu__right__content{display: none}.main-menu__right__content.is-active{display: block}.main-menu__label{color: #0d95ce;font-size: 1.4rem;font-weight: 600;margin-bottom: 15px;width: 100%}.main-menu__container--company .main-menu__label{width: 50%}.main-menu__container-title{position: sticky;z-index: 3;top: 0;color: #494949;font-size: 1.6rem;padding: 10px 0 10px 40px;margin-bottom: 15px;width: 100%;border-top: 1px solid rgba(13,149,206,.5);border-bottom: 1px solid rgba(13,149,206,.5);background-color: #f7f7f7}.main-menu__container-title:before{display: block;content: "";position: absolute;bottom: 100%;left: 0;z-index: 1;width: 100%;height: 200px;border-bottom: 1px solid rgba(13,149,206,.5);background-color: #f7f7f7}.main-menu__container-title:after{display: inline-block;content: "";position: absolute;top: 50%;left: 15px;margin-top: -3px;width: 10px;height: 6px;background-image: url(https://gvhealth.com/wp-content/themes/gvhealthTheme/public/images/icon-arrow-menu.svg);background-repeat: no-repeat;background-position: 50%;-webkit-background-size: contain;background-size: contain;-moz-transform: rotate(90deg);-o-transform: rotate(90deg);-ms-transform: rotate(90deg);-webkit-transform: rotate(90deg);transform: rotate(90deg)}.main-menu__links{display: -webkit-box;display: -moz-box;display: -ms-flexbox;display: -webkit-flex;display: flex;-webkit-flex-direction: column;-moz-flex-direction: column;-ms-flex-direction: column;flex-direction: column;-webkit-flex-flow: wrap;-moz-flex-flow: wrap;-ms-flex-flow: wrap;flex-flow: wrap;-webkit-justify-content: space-between;-moz-justify-content: space-between;-ms-justify-content: space-between;justify-content: space-between;-ms-flex-pack: space-between;width: 100%}.main-menu__links+.btn{margin-top: 20px}.main-menu__link{position: relative;border-bottom: 1px solid hsla(0,0%,43.9%,.25);padding: 13px 0;width: 100%;font-size: 1.4rem;line-height: 1.2;will-change: background-color,color}.main-menu__left--company .main-menu__link,.main-menu__left--knowledge-centre .main-menu__link{width: 100%}.main-menu__link:before{display: inline-block;content: "";width: 0;will-change: width}.main-menu__link:after{display: inline-block;content: "";position: absolute;top: 50%;right: 15px;-moz-transform: rotate(-90deg) translate(30%);-o-transform: rotate(-90deg) translate(30%);-ms-transform: rotate(-90deg) translate(30%);-webkit-transform: rotate(-90deg) translate(30%);transform: rotate(-90deg) translate(30%);width: 10px;height: 6px;background-image: url(https://gvhealth.com/wp-content/themes/gvhealthTheme/public/images/icon-arrow-menu.svg);background-repeat: no-repeat;background-position: 50%;-webkit-background-size: contain;background-size: contain;will-change: transform}.main-menu__link:first-child{border-top: 1px solid hsla(0,0%,43.9%,.25)}.main-menu__left--company .main-menu__link:nth-child(2),.main-menu__left--knowledge-centre .main-menu__link:nth-child(2){border-top-width: 0}.main-menu__sector{position: relative;width: 100%}.main-menu__sector{display: block;max-height: 250px;border-radius: 10px;overflow: hidden;background-position: 50%;background-repeat: no-repeat;-webkit-background-size: cover;background-size: cover;visibility: hidden;opacity: 0;height: 0;will-change: opacity}.main-menu__sector:before{content: "";display: block;padding-bottom: 53%}.main-menu__sector__title{position: absolute;top: 0;left: 0;padding: 20px 30px;width: 100%;font-size: 3.8rem;color: #fff;line-height: 1.2}.main-menu__sector__content{display: block;margin-top: 10px;font-size: 2.1rem;line-height: 1.4}.main-menu__tabs{-webkit-flex-direction: column;-moz-flex-direction: column;-ms-flex-direction: column;flex-direction: column}.main-menu__tabs,.main-menu__tabs__nav{width: 100%;display: -webkit-box;display: -moz-box;display: -ms-flexbox;display: -webkit-flex;display: flex}.main-menu__tabs__tab{position: relative;font-size: 1.3rem;font-weight: 600;color: rgba(73,73,73,.25);margin-bottom: 25px;margin-right: 20px}.main-menu__tabs__tab:after{display: block;content: "";position: absolute;top: 100%;left: 0;width: 0;height: 1px;background-color: #0d95ce;will-change: width}.main-menu__tabs__tab.is-active{color: #0d95ce}.main-menu__tabs__tab.is-active:after{width: 100%}.main-menu__tabs__content{display: none;width: 100%}.main-menu__tabs__content.is-active{display: block}.main-menu__tabs__content .btn{margin-top: 35px}.main-menu__features{width: 100%;display: -webkit-box;display: -moz-box;display: -ms-flexbox;display: -webkit-flex;display: flex;-webkit-flex-direction: column;-moz-flex-direction: column;-ms-flex-direction: column;flex-direction: column;-webkit-justify-content: space-between;-moz-justify-content: space-between;-ms-justify-content: space-between;justify-content: space-between;-ms-flex-pack: space-between;-webkit-flex-flow: wrap;-moz-flex-flow: wrap;-ms-flex-flow: wrap;flex-flow: wrap}.main-menu__features .main-menu__label{display: none}.main-menu__featured{display: block;margin-bottom: 16px;width: 100%;height: 250px;border-radius: 10px;position: relative;overflow: hidden;background-position: 50%;background-repeat: no-repeat;-webkit-background-size: cover;background-size: cover;color: #fff;font-size: 1.6rem}.main-menu__featured__wrapper{position: absolute;top: 0;left: 0;display: -webkit-box;display: -moz-box;display: -ms-flexbox;display: -webkit-flex;display: flex;-webkit-flex-direction: column;-moz-flex-direction: column;-ms-flex-direction: column;flex-direction: column;padding: 20px;width: 100%;height: 100%}.main-menu__featured__category{font-size: 1.3rem;font-weight: 400;margin-bottom: 5px}.main-menu__featured__category,.main-menu__featured__title{-webkit-flex-grow: 0;-moz-flex-grow: 0;-ms-flex-grow: 0;flex-grow: 0}.main-menu__featured__title{font-size: 2.4rem;margin-bottom: 10px}.main-menu__featured__excerpt{-webkit-flex-grow: 2;-moz-flex-grow: 2;-ms-flex-grow: 2;flex-grow: 2;max-width: 250px;margin-bottom: 15px}.main-menu__featured__btn{-webkit-flex-grow: 0;-moz-flex-grow: 0;-ms-flex-grow: 0;flex-grow: 0}.main-menu__products-btn{display: -webkit-box;display: -moz-box;display: -ms-flexbox;display: -webkit-flex;display: flex;-webkit-flex-direction: column;-moz-flex-direction: column;-ms-flex-direction: column;flex-direction: column;-webkit-flex-flow: wrap;-moz-flex-flow: wrap;-ms-flex-flow: wrap;flex-flow: wrap;max-width: 500px}.main-menu__products-btn .btn{margin-right: 10px;margin-bottom: 12px}.main-footer__btn p{display: none;font-size: 1.6rem;margin-bottom: 16px}.home-carousel{background-color: #f7f7f7}.home-carousel .swiper-container{overflow: visible}.home-carousel__slide{position: relative;z-index: 1;height: 100vh}.home-carousel__slide__bg{position: absolute;top: 0;left: 0;z-index: -1;width: 100%;height: 123.5%;object-position: bottom center;object-fit: cover}@media only screen and (max-width:575.98px){.home-carousel__slide--has-mobile .home-carousel__slide__bg{display: none}}.home-carousel__slide__bg-mobile{display: none;position: absolute;top: 0;left: 0;z-index: -1;width: 100%;height: 100%;object-position: top center;object-fit: cover}@media only screen and (max-width:575.98px){.home-carousel__slide__bg-mobile{display: block}}.home-carousel__slide__wrapper{display: -webkit-box;display: -moz-box;display: -ms-flexbox;display: -webkit-flex;display: flex;-webkit-flex-direction: column;-moz-flex-direction: column;-ms-flex-direction: column;flex-direction: column;-webkit-justify-content: flex-end;-moz-justify-content: flex-end;-ms-justify-content: flex-end;justify-content: flex-end;-ms-flex-pack: flex-end;-webkit-align-content: flex-start;-moz-align-content: flex-start;-ms-align-content: flex-start;align-content: flex-start;height: 100vh;padding: 30px;color: #fff;line-height: 1.75;font-size: 14px}.home-carousel__slide__title{line-height: 1.2;margin-bottom: 10px;font-size: 35px}@media only screen and (max-width:575.98px){.home-carousel__slide__title br{display: none}}.home-carousel__slide__content{margin-bottom: 30px;width: 83.33333%}.home-carousel .swiper-pagination{margin-bottom: 20px}.home-accordion__heading{display: none;font-size: 2.4rem;margin-bottom: 25px}.home-accordion__content__text{display: none;font-size: 1.2rem;line-height: 1.5}.is-active .home-accordion__content__text{padding-bottom: 25px}.home-accordion__content__btn{display: block;margin-top: 10px}.home-banner__video{position: absolute;top: 0;left: 0;width: 100%;height: 100%}.home-banner__video{display: none;z-index: 10}.home-banner__video__close{position: absolute;z-index: 2;right: 20px;top: 20px;width: 20px;height: 20px;background-image: url(https://gvhealth.com/wp-content/themes/gvhealthTheme/public/images/icons/icon-close.svg);background-position: 50%;background-repeat: no-repeat;-webkit-background-size: contain;background-size: contain}.home-banner__video video{position: relative;z-index: 1;height: 100%;width: 100%;object-position: center center;object-fit: cover}
        </style>
        <link rel="preconnect" href="https://fonts.gstatic.com/" />
        <link href="https://fonts.googleapis.com/css2?family=Exo:wght@300;400;500;600;700&display=swap" rel="preload" as="style" onload="this.rel='stylesheet'">

        <?php $css = get_template_directory_uri() . '/public/css/app.min.css'; 
        $css_time = filemtime(get_template_directory() . '/public/css/app.min.css'); ?>
        <link rel="preload" href="<?php echo $css.'?ver='.$css_time; ?>" as="style">

        <link rel="apple-touch-icon" sizes="57x57" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/apple-icon-57x57.png">
        <link rel="apple-touch-icon" sizes="60x60" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/apple-icon-60x60.png">
        <link rel="apple-touch-icon" sizes="72x72" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/apple-icon-72x72.png">
        <link rel="apple-touch-icon" sizes="76x76" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/apple-icon-76x76.png">
        <link rel="apple-touch-icon" sizes="114x114" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/apple-icon-114x114.png">
        <link rel="apple-touch-icon" sizes="120x120" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/apple-icon-120x120.png">
        <link rel="apple-touch-icon" sizes="144x144" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/apple-icon-144x144.png">
        <link rel="apple-touch-icon" sizes="152x152" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/apple-icon-152x152.png">
        <link rel="apple-touch-icon" sizes="180x180" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/apple-icon-180x180.png">
        <link rel="icon" type="image/png" sizes="192x192"  href="<?php bloginfo( 'template_url' ); ?>/public/favicon/android-icon-192x192.png">
        <link rel="icon" type="image/png" sizes="32x32" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/favicon-32x32.png">
        <link rel="icon" type="image/png" sizes="96x96" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/favicon-96x96.png">
        <link rel="icon" type="image/png" sizes="16x16" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/favicon-16x16.png">
        <link rel="manifest" href="<?php bloginfo( 'template_url' ); ?>/public/favicon/manifest.json">
        <meta name="msapplication-TileColor" content="#0D95CE">
        <meta name="msapplication-TileImage" content="<?php bloginfo( 'template_url' ); ?>/public/favicon//ms-icon-144x144.png">
        <meta name="theme-color" content="#0D95CE">

        <?php wp_head(); ?>        
    </head>

    <body <?php body_class(); ?>>

        <?php
            $header = get_field('header', 'options');
            $logo = $header['logo']['url'];
            $logoHome = $header['logo_homepage']['url'];
            $menu = $header['menu_ref'];
            $btns = $header['buttons'];
        ?>
        <header class="main-header">
            <div class="main-header__container container container--fluid">
                <a class="main-header__logo" href="<?php echo get_home_url('/'); ?>" title="<?php echo get_bloginfo( 'name' ); ?>">
                    <?php if ( is_front_page() ) : ?>
                        <img src="<?php echo $logoHome; ?>" width="140" height="57" alt="<?php echo get_bloginfo( 'name' ); ?>">
                        <img src="<?php echo $logo; ?>" width="140" height="57" alt="<?php echo get_bloginfo( 'name' ); ?>">
                    <?php else : ?>
                        <img src="<?php echo $logo; ?>" width="140" height="57" alt="<?php echo get_bloginfo( 'name' ); ?>">
                    <?php endif; ?>
                </a>
                <div class="main-header__btn">
                    <span class="main-header__btn__line"></span>
                    <span class="main-header__btn__line"></span>
                    <span class="main-header__btn__line"></span>
                </div>
                <nav class="main-header__nav">
                    <?php foreach ( $menu as $index=>$item ) : ?>
                        <a href="<?php echo $item['link']['url']; ?>"
                           class="main-header__nav__link"
                        ><?php echo $item['link']['title']; ?></a>
                    <?php endforeach; ?>
                    <?php foreach ( $btns as $btn ) : ?>
                        <?php
                            $btnVar = $btn;
                            include( locate_template( 'partials/button.php', false, false ) );
                        ?>
                    <?php endforeach; ?>
                </nav>
            </div>
        </header>

        <?php get_template_part('sections/main-menu/index'); ?>

        <main id="main">

