<?php
    
    function get_social_share_56 (string $class, array $socials, string $heading = '') {
        // Get current page URL
        $crunchifyURL = urlencode(get_permalink());

        // Get current page title
        $crunchifyTitle = htmlspecialchars(urlencode(html_entity_decode(get_the_title(), ENT_COMPAT, 'UTF-8')), ENT_COMPAT, 'UTF-8');
        // $crunchifyTitle = str_replace( ' ', '%20', get_the_title());

        // Get Post Thumbnail for pinterest
        // $crunchifyThumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );

        // URL arrays

        $socialUrls = array (
            'twitter' => 'https://twitter.com/intent/tweet?text='.$crunchifyTitle.'&amp;url='.$crunchifyURL.'&amp;via=Crunchify',
            'facebook' => 'https://www.facebook.com/sharer/sharer.php?u='.$crunchifyURL,
            'google' => 'https://plus.google.com/share?url='.$crunchifyURL,
            'buffer' =>  'https://bufferapp.com/add?url='.$crunchifyURL.'&amp;text='.$crunchifyTitle,
            'linkedin' => 'https://www.linkedin.com/shareArticle?mini=true&url='.$crunchifyURL.'&amp;title='.$crunchifyTitle,
            // 'pinterest' => 'https://pinterest.com/pin/create/button/?url='.$crunchifyURL.'&amp;media='.$crunchifyThumbnail[0].'&amp;description='.$crunchifyTitle,
        );

        // Add sharing button at the end of page/page content
        $shareLinks = '<div class="'.$class.'">';

        ($heading !== '') ? $shareLinks .= '<span class="'.$class.'__heading">'.$heading.'</span>' : '';

        foreach ( $socialUrls  as $social => $url) {
            ( in_array(strtolower($social), $socials) ) ? $shareLinks .= '<a class="'.$class.'__link '.$social.'" href="'. $url .'" target="_blank">'.$social.'</a>' : '';
        }
        
        $shareLinks .= '</div>';

        return $shareLinks;
    }
?>