<?php
/**
 * Remove parameters from url
 */
add_action( 'wp', 'process_post' );
function process_post() {
    if( isset( $_GET['start'] ) || isset( $_GET['id'] ) || isset( $_GET['itemid'] ) || isset( $_GET['catid'] ) || isset( $_GET['layout'] ) ) {
        global $wp;
        $queryParams = $_GET;
        unset($queryParams['start']);
        unset($queryParams['id']);
        unset($queryParams['itemid']);
        unset($queryParams['catid']);
        unset($queryParams['layout']);
        $current_url = home_url(add_query_arg($queryParams, $wp->request));

        wp_redirect($current_url);
        die();
    } else if ( isset( $_GET['category'] )  ) {
        global $wp;
        $queryParams = $_GET;
        unset($queryParams['start']);
        $current_url = home_url(add_query_arg($queryParams, $wp->request));

        if ( strpos($current_url, '?start=') ) {
            if ( strpos($current_url, '?start=20') ) {
                $current_url_new = str_replace( '?start=20', '', $current_url);
            } else if ( strpos($current_url, '?start=40')  ) {
                $current_url_new = str_replace( '?start=40', '', $current_url);
            }

            wp_redirect($current_url_new);
            die();
        }
    }
}
// /end Remove parameters from url

/* Disable the Gutenberg editor. */
 add_filter('use_block_editor_for_post', '__return_false');
 add_filter('use_block_editor_for_post_type', '__return_false', 10);

show_admin_bar( false );
add_theme_support( 'menus' );
add_theme_support( 'post-thumbnails' );
add_image_size( 'largeRetina', 2048, 0, true );
add_image_size( 'placeholder', 150, 0, true );
add_filter( 'xmlrpc_enabled', '__return_false' );

register_nav_menu('top_menu', 'Top menu');


remove_filter( 'the_excerpt', 'wpautop' );

/**
 * Disable edit themes in WP Panel
 */
define( 'DISALLOW_FILE_EDIT', true );

/**
 * Hide ACF Menu
 */
function hide_acf_menu() {
	$current_user = wp_get_current_user();
	if($current_user->ID != '1') {
		remove_menu_page('edit.php?post_type=acf-field-group');
	}
}
add_action('admin_menu', 'hide_acf_menu', 100);

add_action('init', 'fsdegrees_init_actions');
function fsdegrees_init_actions() {
	remove_action( 'admin_print_styles', 'print_emoji_styles' );
	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
	remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
	remove_action( 'wp_print_styles', 'print_emoji_styles' );
	remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
	remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
	remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );
	remove_action( 'wp_head', 'feed_links_extra', 3);
	remove_action( 'wp_head', 'feed_links', 2);
	remove_action( 'wp_head', 'rsd_link');
	remove_action( 'wp_head', 'wlwmanifest_link');
	remove_action( 'wp_head', 'index_rel_link');
	remove_action( 'wp_head', 'parent_post_rel_link', 10 ,0);
	remove_action( 'wp_head', 'start_post_rel_link', 10 ,0);
	remove_action( 'wp_head', 'adjacent_posts_rel_link', 10, 0);
	remove_action( 'wp_head', 'wp_generator');
	remove_action( 'wp_head', 'rel_canonical');

	add_rewrite_rule(
		'^search\/([^\/]+)(\/in\/([^\/]+))?(\/page\/([^\/]+))?\/?$',
		'index.php?s=$matches[1]&sin=$matches[3]&paged=$matches[5]',
		'top' );
		
}

/**
 * Add custom logo in wp-admin
 */
function fsdegrees_login_logo_url() {
    return home_url();
}
add_filter( 'login_headerurl', 'fsdegrees_login_logo_url' );

function fsdegrees_login_logo_url_title() {
    return the_title();
}
add_filter( 'login_headertitle', 'fsdegrees_login_logo_url_title' );

function fsdegrees_login_logo() { ?>
    <style type="text/css">
        #login h1 a, .login h1 a {
			background-image: url(<?php echo get_stylesheet_directory_uri(); ?>/public/images/GV-Health_logo.svg);
			-webkit-background-size: contain;
         	-moz-background-size: contain;
            -o-background-size: contain;
			background-size: contain;
			background-repeat: no-repeat;
			height: 80px;
			width: 320px;
        }
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'fsdegrees_login_logo' );

/**
 * Remove Admin Menu Link to Theme Customizer
 */
add_action( 'admin_menu', function () {
    global $submenu;

    if ( isset( $submenu[ 'themes.php' ] ) ) {
        foreach ( $submenu[ 'themes.php' ] as $index => $menu_item ) {
            if ( in_array( 'customize', $menu_item ) ) {
                unset( $submenu[ 'themes.php' ][ $index ] );
            }
        }
    }
});

function remove_menus(){
  	remove_menu_page( 'edit-comments.php' );          //Comments
}
add_action( 'admin_menu', 'remove_menus' );

/**
 * Customize Menu Item Classes
 * @author Bill Erickson
 * @link http://www.billerickson.net/customize-which-menu-item-is-marked-active/
 *
 * @param array $classes, current menu classes
 * @param object $item, current menu item
 * @param object $args, menu arguments
 * @return array $classes
 */
function be_menu_item_classes( $classes, $item, $args ) {

    if( ( is_singular( 'collections' ) ) && 'Collections' == $item->title )
        $classes[] = 'current-menu-item';

	return array_unique( $classes );
}
add_filter( 'nav_menu_css_class', 'be_menu_item_classes', 10, 3 );

add_action( 'pre_get_posts',  'set_posts_per_page'  );
function set_posts_per_page( $query ) {

	global $wp_the_query;

	// is_home 
	if ( ( ! is_admin() ) && ( $query === $wp_the_query ) && ( $query->is_home() ) ) {
		$query->set( 'posts_per_page', 1 );
	}
	// elseif ( ( ! is_admin() ) && ( $query === $wp_the_query ) && ( $query->is_home() ) ) {
	// 	$query->set( 'posts_per_page', 1 );
	// }
	// Etc..

	return $query;
}

/**
 * Custom navigation
 */

function wpbeginner_numeric_posts_nav() {

    if( is_singular() )
        return;

    global $wp_query;

    /** Stop execution if there's only 1 page */
    if( $wp_query->max_num_pages <= 1 )
        return;

    $paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
    $max   = intval( $wp_query->max_num_pages );

    /** Add current page to the array */
    if ( $paged >= 1 )
        $links[] = $paged;

    /** Add the pages around the current page to the array */
    if ( $paged >= 3 ) {
        $links[] = $paged - 1;
        $links[] = $paged - 2;
    }

    if ( ( $paged + 2 ) <= $max ) {
        $links[] = $paged + 2;
        $links[] = $paged + 1;
    }

    echo '<ul class="pagination">' . "\n";

    /** Previous Post Link */
    if ( get_previous_posts_link() )
        printf( '<li>%s</li>' . "\n", get_previous_posts_link('<') );

    /** Link to first page, plus ellipses if necessary */
    if ( ! in_array( 1, $links ) ) {
        $class = 1 == $paged ? ' class="active"' : '';

        printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( 1 ) ), '1' );

        if ( ! in_array( 2, $links ) )
            echo '<li>…</li>';
    }

    /** Link to current page, plus 2 pages in either direction if necessary */
    sort( $links );
    foreach ( (array) $links as $link ) {
        $class = $paged == $link ? ' class="active"' : '';
        printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $link ) ), $link );
    }

    /** Link to last page, plus ellipses if necessary */
    if ( ! in_array( $max, $links ) ) {
        if ( ! in_array( $max - 1, $links ) )
            echo '<li>…</li>' . "\n";

        $class = $paged == $max ? ' class="active"' : '';
        printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $max ) ), $max );
    }

    /** Next Post Link */
    if ( get_next_posts_link() )
        printf( '<li>%s</li>' . "\n", get_next_posts_link('>') );

    echo '</ul>' . "\n";

}


// Allow SVG
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {

    global $wp_version;
    if ( $wp_version !== '4.7.1' ) {
        return $data;
    }

    $filetype = wp_check_filetype( $filename, $mimes );

    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];

}, 10, 4 );

function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter( 'upload_mimes', 'cc_mime_types' );

function fix_svg() {
    echo '<style type="text/css">
        .attachment-266x266, .thumbnail img {
             width: 100% !important;
             height: auto !important;
        }
        </style>';
}
add_action( 'admin_head', 'fix_svg' );

function year_shortcode() {
    $year = date('Y');
    return $year;
}
add_shortcode('year', 'year_shortcode');

function my_disable_post_revisions() {
    foreach ( get_post_types() as $post_type ) {
        remove_post_type_support( $post_type, 'revisions' );
    }
}
add_action( 'init', 'my_disable_post_revisions', 999 );

function favicon4admin() {
    echo '<link rel="apple-touch-icon" sizes="57x57" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/apple-icon-57x57.png">';
    echo '<link rel="apple-touch-icon" sizes="60x60" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/apple-icon-60x60.png">';
    echo '<link rel="apple-touch-icon" sizes="72x72" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/apple-icon-72x72.png">';
    echo '<link rel="apple-touch-icon" sizes="76x76" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/apple-icon-76x76.png">';
    echo '<link rel="apple-touch-icon" sizes="114x114" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/apple-icon-114x114.png">';
    echo '<link rel="apple-touch-icon" sizes="120x120" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/apple-icon-120x120.png">';
    echo '<link rel="apple-touch-icon" sizes="144x144" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/apple-icon-144x144.png">';
    echo '<link rel="apple-touch-icon" sizes="152x152" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/apple-icon-152x152.png">';
    echo '<link rel="apple-touch-icon" sizes="180x180" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/apple-icon-180x180.png">';
    echo '<link rel="icon" type="image/png" sizes="192x192"  href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/android-icon-192x192.png">';
    echo '<link rel="icon" type="image/png" sizes="32x32" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/favicon-32x32.png">';
    echo '<link rel="icon" type="image/png" sizes="96x96" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/favicon-96x96.png">';
    echo '<link rel="icon" type="image/png" sizes="16x16" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/favicon-16x16.png">';
    echo '<link rel="manifest" href="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon/manifest.json">';
    echo '<meta name="msapplication-TileColor" content="#0D95CE">';
    echo '<meta name="msapplication-TileImage" content="'. get_bloginfo('wpurl') .'/wp-content/themes/gvhealthTheme/public/favicon//ms-icon-144x144.png">';
    echo '<meta name="theme-color" content="#0D95CE">';
}
add_action( 'admin_head', 'favicon4admin' );