<?php
// Register Custom Post Type Vacancies
function create_vacancies_cpt() {

    $labels = array(
        'name' => _x( 'Vacancies', 'Post Type General Name', 'textdomain' ),
        'singular_name' => _x( 'Vacancies', 'Post Type Singular Name', 'textdomain' ),
        'menu_name' => _x( 'Vacancies', 'Admin Menu text', 'textdomain' ),
        'name_admin_bar' => _x( 'Vacancies', 'Add New on Toolbar', 'textdomain' ),
        'archives' => __( 'Vacancies Archives', 'textdomain' ),
        'attributes' => __( 'Vacancies Attributes', 'textdomain' ),
        'parent_item_colon' => __( 'Parent Vacancies:', 'textdomain' ),
        'all_items' => __( 'All Vacancies', 'textdomain' ),
        'add_new_item' => __( 'Add New Vacancies', 'textdomain' ),
        'add_new' => __( 'Add New', 'textdomain' ),
        'new_item' => __( 'New Vacancies', 'textdomain' ),
        'edit_item' => __( 'Edit Vacancies', 'textdomain' ),
        'update_item' => __( 'Update Vacancies', 'textdomain' ),
        'view_item' => __( 'View Vacancies', 'textdomain' ),
        'view_items' => __( 'View Vacancies', 'textdomain' ),
        'search_items' => __( 'Search Vacancies', 'textdomain' ),
        'not_found' => __( 'Not found', 'textdomain' ),
        'not_found_in_trash' => __( 'Not found in Trash', 'textdomain' ),
        'featured_image' => __( 'Featured Image', 'textdomain' ),
        'set_featured_image' => __( 'Set featured image', 'textdomain' ),
        'remove_featured_image' => __( 'Remove featured image', 'textdomain' ),
        'use_featured_image' => __( 'Use as featured image', 'textdomain' ),
        'insert_into_item' => __( 'Insert into Vacancies', 'textdomain' ),
        'uploaded_to_this_item' => __( 'Uploaded to this Vacancies', 'textdomain' ),
        'items_list' => __( 'Vacancies list', 'textdomain' ),
        'items_list_navigation' => __( 'Vacancies list navigation', 'textdomain' ),
        'filter_items_list' => __( 'Filter Vacancies list', 'textdomain' ),
    );
    $args = array(
        'label' => __( 'Vacancies', 'textdomain' ),
        'description' => __( '', 'textdomain' ),
        'labels' => $labels,
        'menu_icon' => 'dashicons-businessman',
        'supports' => array('title'),
        'taxonomies' => array(),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 5,
        'show_in_admin_bar' => true,
        'show_in_nav_menus' => true,
        'can_export' => true,
        'has_archive' => false,
        'hierarchical' => false,
        'exclude_from_search' => false,
        'show_in_rest' => true,
        'publicly_queryable' => true,
        'capability_type' => 'post',
    );
    register_post_type( 'vacancies', $args );

}
add_action( 'init', 'create_vacancies_cpt', 0 );