<?php
// Register Custom Post Type Sector
function create_sector_cpt() {

    $labels = array(
        'name' => _x( 'Sectors', 'Post Type General Name', 'textdomain' ),
        'singular_name' => _x( 'Sector', 'Post Type Singular Name', 'textdomain' ),
        'menu_name' => _x( 'Sectors', 'Admin Menu text', 'textdomain' ),
        'name_admin_bar' => _x( 'Sector', 'Add New on Toolbar', 'textdomain' ),
        'archives' => __( 'Sector Archives', 'textdomain' ),
        'attributes' => __( 'Sector Attributes', 'textdomain' ),
        'parent_item_colon' => __( 'Parent Sector:', 'textdomain' ),
        'all_items' => __( 'All Sectors', 'textdomain' ),
        'add_new_item' => __( 'Add New Sector', 'textdomain' ),
        'add_new' => __( 'Add New', 'textdomain' ),
        'new_item' => __( 'New Sector', 'textdomain' ),
        'edit_item' => __( 'Edit Sector', 'textdomain' ),
        'update_item' => __( 'Update Sector', 'textdomain' ),
        'view_item' => __( 'View Sector', 'textdomain' ),
        'view_items' => __( 'View Sectors', 'textdomain' ),
        'search_items' => __( 'Search Sector', 'textdomain' ),
        'not_found' => __( 'Not found', 'textdomain' ),
        'not_found_in_trash' => __( 'Not found in Trash', 'textdomain' ),
        'featured_image' => __( 'Featured Image', 'textdomain' ),
        'set_featured_image' => __( 'Set featured image', 'textdomain' ),
        'remove_featured_image' => __( 'Remove featured image', 'textdomain' ),
        'use_featured_image' => __( 'Use as featured image', 'textdomain' ),
        'insert_into_item' => __( 'Insert into Sector', 'textdomain' ),
        'uploaded_to_this_item' => __( 'Uploaded to this Sector', 'textdomain' ),
        'items_list' => __( 'Sectors list', 'textdomain' ),
        'items_list_navigation' => __( 'Sectors list navigation', 'textdomain' ),
        'filter_items_list' => __( 'Filter Sectors list', 'textdomain' ),
    );
    $args = array(
        'label' => __( 'Sector', 'textdomain' ),
        'description' => __( '', 'textdomain' ),
        'labels' => $labels,
        'menu_icon' => 'dashicons-chart-pie',
        'supports' => array('title'),
        'taxonomies' => array(),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 5,
        'show_in_admin_bar' => true,
        'show_in_nav_menus' => true,
        'can_export' => true,
        'has_archive' => false,
        'hierarchical' => false,
        'exclude_from_search' => false,
        'show_in_rest' => true,
        'publicly_queryable' => true,
        'capability_type' => 'post',
    );
    register_post_type( 'sector', $args );

}
add_action( 'init', 'create_sector_cpt', 0 );