<?php
// Register Custom Post Type Product
function create_product_cpt()
{

    $labels = array(
        'name' => _x('Products', 'Post Type General Name', 'textdomain'),
        'singular_name' => _x('Product', 'Post Type Singular Name', 'textdomain'),
        'menu_name' => _x('Products', 'Admin Menu text', 'textdomain'),
        'name_admin_bar' => _x('Product', 'Add New on Toolbar', 'textdomain'),
        'archives' => __('Product Archives', 'textdomain'),
        'attributes' => __('Product Attributes', 'textdomain'),
        'parent_item_colon' => __('Parent Product:', 'textdomain'),
        'all_items' => __('All Products', 'textdomain'),
        'add_new_item' => __('Add New Product', 'textdomain'),
        'add_new' => __('Add New', 'textdomain'),
        'new_item' => __('New Product', 'textdomain'),
        'edit_item' => __('Edit Product', 'textdomain'),
        'update_item' => __('Update Product', 'textdomain'),
        'view_item' => __('View Product', 'textdomain'),
        'view_items' => __('View Products', 'textdomain'),
        'search_items' => __('Search Product', 'textdomain'),
        'not_found' => __('Not found', 'textdomain'),
        'not_found_in_trash' => __('Not found in Trash', 'textdomain'),
        'featured_image' => __('Featured Image', 'textdomain'),
        'set_featured_image' => __('Set featured image', 'textdomain'),
        'remove_featured_image' => __('Remove featured image', 'textdomain'),
        'use_featured_image' => __('Use as featured image', 'textdomain'),
        'insert_into_item' => __('Insert into Product', 'textdomain'),
        'uploaded_to_this_item' => __('Uploaded to this Product', 'textdomain'),
        'items_list' => __('Products list', 'textdomain'),
        'items_list_navigation' => __('Products list navigation', 'textdomain'),
        'filter_items_list' => __('Filter Products list', 'textdomain'),
    );
    $args = array(
        'label' => __('Product', 'textdomain'),
        'description' => __('', 'textdomain'),
        'labels' => $labels,
        'menu_icon' => 'dashicons-portfolio',
        'supports' => array('title', 'page-attributes'),
        'taxonomies' => array(),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 5,
        'show_in_admin_bar' => true,
        'show_in_nav_menus' => true,
        'can_export' => true,
        'has_archive' => false,
        'hierarchical' => true,
        'exclude_from_search' => false,
        'show_in_rest' => true,
        'publicly_queryable' => true,
        'capability_type' => 'post',
        'rewrite' => array('slug' => 'product', 'with_front' => false),
    );
    register_post_type('product', $args);
}
add_action('init', 'create_product_cpt', 0);


function change_columns( $cols ) {
    $cols = array(
        'cb'         => '<input type="checkbox" />',
        'title'      => 'Title',
        'product_code'     => 'Product Code',
        'date'       => 'Release Date'
    );
    return $cols;
}
function custom_columns( $column ) {
    global $post;
    if( $column == 'product_code' ) {
        $artist = get_field('product_code');
        if( $artist ) {
            echo $artist;
        } else {
            echo '-';
        }
    }
}
add_action( "manage_product_posts_custom_column", "custom_columns", 10, 2 );
add_filter( "manage_product_posts_columns", "change_columns" );