<?php
// Route for Posts
add_action( 'rest_api_init', 'register_posts_route' );

function register_posts_route() {
    register_rest_route( 'get', 'knowledge-centre', array(
        'methods'  => 'GET',
        'callback' => 'knowledgeCentre_endpoint',
        'permission_callback' => '__return_true'
    ) );

    register_rest_route( 'get', 'sectors', array(
        'methods'  => 'GET',
        'callback' => 'sectors_endpoint',
        'permission_callback' => '__return_true'
    ) );

    register_rest_route( 'post', 'products', array(
        'methods'  => 'POST',
        'callback' => 'products_endpoint',
        'permission_callback' => '__return_true'
    ) );

    register_rest_route( 'post', 'products-sector', array(
        'methods'  => 'POST',
        'callback' => 'products_sector_endpoint',
        'permission_callback' => '__return_true'
    ) );

    register_rest_route( 'get', 'products_search/(?P<s>([a-zA-Z0-9-]|%20)+)', array(
        'methods'  => 'GET',
        'callback' => 'products_search_endpoint',
        'permission_callback' => '__return_true'
    ) );
}

function knowledgeCentre_endpoint() {
    $args_query = array(
        'post_type' => 'knowledge-centre',
        'posts_per_page' => -1,
        'order' => 'DESC',
    );

    $query = new WP_Query( $args_query );

    $posts = array();

    if ( $query->have_posts() ) {
        while ( $query->have_posts() ) {
            $query->the_post();

//            $feat_image = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large' )[0];
            $terms = get_the_terms( get_the_ID() , 'knowledge-centre-category' );

            $item = array(
                'title' => get_the_title(),
                'url' => get_the_permalink(),
                'bg' => get_field('background_image'),
                'bgPortrait' => get_field('background_image_portrait'),
                'gradient' => get_field('background_gradient'),
                'textColor' => get_field('text_color'),
                'excerpt' => get_field('the_excerpt'),
                'logo' => get_field('logo'),
                'quote' => get_field('quote'),
                'author' => get_field('author'),
                'categories' => $terms,
                'categories_icon' => get_field( 'icon', 'knowledge-centre-category' . '_' . $terms[0]->term_id),
                'categories_icon_dark' => get_field( 'icon_dark', 'knowledge-centre-category' . '_' . $terms[0]->term_id),
                'sectors' =>  get_field( 'sectors' ),
                'show_home' => get_field( 'dont_show_on_home_page' )
            );

            $posts[] = $item;
        }
    }

    /*
     * All sectors
     */
    $sectors = array();

    // Custom WP query query_sector
    $args_query_sector = array(
        'post_type' => array('sector'),
        'posts_per_page' => -1,
        'order' => 'DESC',
    );

    $query_sector = new WP_Query( $args_query_sector );

    if ( $query_sector->have_posts() ) {
        while ($query_sector->have_posts()) {
            $query_sector->the_post();

            $item = array(
                'name' => get_the_title(),
                'slug' => get_post_field( 'post_name' )
            );

            $sectors[] = $item;
        }
    }

    /**
     * Taxonomy category
     */
    $categories = get_terms( array(
        'taxonomy' => 'knowledge-centre-category',
        'hide_empty' => false
    ) );

    $response = array(
        'posts' => $posts,
        'sectors' => $sectors,
        'categories' => $categories
    );

    return rest_ensure_response( $response );
}

function sectors_endpoint() {
    $sectors = array();

    // Custom WP query query_sector
    $args_query_sector = array(
        'post_type' => array('sector'),
        'posts_per_page' => -1,
        'order' => 'DESC',
    );

    $query_sector = new WP_Query( $args_query_sector );

    if ( $query_sector->have_posts() ) {
        while ($query_sector->have_posts()) {
            $query_sector->the_post();

            $box = get_field('box');

            $item = array(
                'id' => get_the_ID(),
                'link' => get_the_permalink(),
                'title' => get_the_title(),
                'slug' => get_post_field( 'post_name' ),
                'box' => array(
                    'title' => $box['title'],
                    'bg' => $box['background'],
                    'content' => $box['content'],
                )
            );

            $sectors[] = $item;
        }
    }

    $response = array(
        'sectors' => $sectors
    );

    return rest_ensure_response( $response );
}


function products_endpoint($request) {
    $term = json_decode($request['taxonomy']);
//    var_dump($term);
//    die();
    $products = array();

    $tax_query = array('relation' => 'AND');
    if ($term->taxonomy === 'product-type') {
        $tax_query[] =  array(
            'taxonomy' => 'product-type',
            'field' => 'term_id',
            'terms' => $term->term_id,
            'operator' => 'IN',
        );
    } else if ($term->taxonomy === 'service') {
        $tax_query[] =  array(
            'taxonomy' => 'service',
            'field' => 'term_id',
            'terms' => $term->term_id,
            'operator' => 'IN',
        );
    }

    // Custom WP query query_products
    $args_query_products = array(
        'post_type' => array('product'),
        'posts_per_page' => -1,
        'order' => 'DESC',
        'tax_query' => $tax_query,
    );

    $query_products = new WP_Query( $args_query_products );

    if ( $query_products->have_posts() ) {
        while ($query_products->have_posts()) {
            $query_products->the_post();

            $parent = $query_products->post->post_parent;
            $box = get_field('box');
            $boxImage = ( get_field('box')['image'] ) ? get_field('box')['image'] : get_field('box', $parent)['image'];
            $boxExcerpt = ( get_field('box')['excerpt'] ) ? get_field('box')['excerpt'] : get_field('box', $parent)['excerpt'];

            $desc = wp_trim_words(get_field('product_description'), $num_words = 20, $more = '...');


            $item = array(
                'parent' => get_field('box', $parent),
                'id' => get_the_ID(),
                'url' => get_the_permalink(),
                'title' => get_the_title(),
                'slug' => get_post_field( 'post_name' ),
                'box' => array(
                    'code' => get_field('product_code'),
                    'sizes' => get_field('product_sizes', false, false),
                    'image' => $boxImage,
                    'excerpt' => ( $boxExcerpt ) ? $boxExcerpt : $desc,
                )
            );

            $products[] = $item;
        }
    }

    $response = array(
        'products' => $products
    );

    return rest_ensure_response( $response );
}

function products_sector_endpoint($request) {
    $sector = json_decode($request['sector']);
//    var_dump($sector);
//    die();
    $products = array();

    // Custom WP query query_products
    $args_query_products = array(
        'post_type' => array('product'),
        'posts_per_page' => -1,
        'order' => 'DESC',
        'post_parent' => 0,
        'meta_query' => array(
            array(
                'key' => 'sectors',
                'value' => $sector,
                'compare' => 'LIKE'
            )
        )
    );

    $query_products = new WP_Query( $args_query_products );

    if ( $query_products->have_posts() ) {
        while ($query_products->have_posts()) {
            $query_products->the_post();

            $box = get_field('box');

            $desc = wp_trim_words(get_field('product_description'), $num_words = 20, $more = '...');

            $item = array(
                'id' => get_the_ID(),
                'url' => get_the_permalink(),
                'title' => get_the_title(),
                'slug' => get_post_field( 'post_name' ),
                'box' => array(
                    'code' => get_field('product_code'),
                    'sizes' => get_field('product_sizes', false, false),
                    'image' => $box['image'],
                    'excerpt' => ( $box['excerpt'] ) ? $box['excerpt'] : $desc,
                )
            );

            /**
             * Children pages
             */
            /*
            $args_query_productsChildren = array(
                'post_type' => array('product'),
                'posts_per_page' => -1,
                'order' => 'DESC',
                'post_parent'    => get_the_ID(),
            );

            $query_productsChildren = new WP_Query( $args_query_productsChildren );

            if ( $query_productsChildren->have_posts() ) {
                while ($query_productsChildren->have_posts()) {
                    $query_productsChildren->the_post();

                    $parent = $query_productsChildren->post->post_parent;
                    $box = get_field('box');
                    $boxImage = ( get_field('box')['image'] ) ? get_field('box')['image'] : get_field('box', $parent)['image'];
                    $boxExcerpt = ( get_field('box')['excerpt'] ) ? get_field('box')['excerpt'] : get_field('box', $parent)['excerpt'];

                    $desc = wp_trim_words(get_field('product_description'), $num_words = 20, $more = '...');


                    $itemChildren = array(
                        'parent' => get_field('box', $parent),
                        'id' => get_the_ID(),
                        'url' => get_the_permalink(),
                        'title' => get_the_title(),
                        'slug' => get_post_field( 'post_name' ),
                        'box' => array(
                            'code' => get_field('product_code'),
                            'sizes' => get_field('product_sizes', false, false),
                            'image' => $boxImage,
                            'excerpt' => ( $boxExcerpt ) ? $boxExcerpt : $desc,
                        )
                    );

                    $products[] = $itemChildren;
                }
                wp_reset_postdata();
            }
            */


            $products[] = $item;
            //var_dump($products);
            //die();
        }
    }

    $response = array(
        'products' => $products
    );

    return rest_ensure_response( $response );
}

function products_search_endpoint($request) {

    function add_join_wpse_99849($joins) {
        global $wpdb;
        return $joins . " INNER JOIN {$wpdb->postmeta} ON ({$wpdb->posts}.ID = {$wpdb->postmeta}.post_id)";
    }
      
    function alter_search_wpse_99849($search,$qry) {
        global $wpdb;
        $add = $wpdb->prepare("({$wpdb->postmeta}.meta_key = 'product_code' AND CAST({$wpdb->postmeta}.meta_value AS CHAR) LIKE '%%%s%%')",$qry->get('s'));
        $pat = '|\(\((.+)\)\)|';
        $search = preg_replace($pat,'(($1 OR '.$add.'))',$search);
        return $search;
    }

    $search = urldecode($request['s']);

    $products = array();

    

    // add_filter('posts_join','add_join_wpse_99849');
    // add_filter('posts_search','alter_search_wpse_99849',1,2);

    /************************************************************************\
    |**                                                                    **|
    |**  Allow WP_Query() search function to look for multiple keywords    **|
    |**  in metas in addition to post_title and post_content               **|
    |**                                                                    **|
    |**  By rAthus @ Arkanite                                              **|
    |**  Created: 2020-08-18                                               **|
    |**  Updated: 2020-08-19                                               **|
    |**                                                                    **|
    |**  Just use the usual 's' argument and add a 's_meta_keys' argument  **|
    |**  containing an array of the meta(s) key you want to search in :)   **|
    |**                                                                    **|
    |**  Example :                                                         **|
    |**                                                                    **|
    |**  $args = array(                                                    **|
    |**      'numberposts'  => -1,                                         **|
    |**      'post_type' => 'post',                                        **|
    |**      's' => $MY_SEARCH_STRING,                                     **|
    |**      's_meta_keys' => array('META_KEY_1','META_KEY_2');            **|
    |**      'orderby' => 'date',                                          **|
    |**      'order'   => 'DESC',                                          **|
    |**  );                                                                **|
    |**  $posts = new WP_Query($args);                                     **|
    |**                                                                    **|
    \************************************************************************/
    add_action('pre_get_posts', 'my_search_query'); // add the special search fonction on each get_posts query (this includes WP_Query())
    function my_search_query($query) {
        if ($query->is_search() and $query->query_vars and $query->query_vars['s'] and $query->query_vars['s_meta_keys']) { // if we are searching using the 's' argument and added a 's_meta_keys' argument
            global $wpdb;
            $search = $query->query_vars['s']; // get the search string
            $ids = array(); // initiate array of martching post ids per searched keyword
            foreach (explode(' ',$search) as $term) { // explode keywords and look for matching results for each
                $term = trim($term); // remove unnecessary spaces
                if (!empty($term)) { // check the the keyword is not empty
                    $query_posts = $wpdb->prepare("SELECT * FROM {$wpdb->posts} WHERE post_status='publish' AND ((post_title LIKE '%%%s%%') OR (post_content LIKE '%%%s%%'))", $term, $term); // search in title and content like the normal function does
                    $ids_posts = [];
                    $results = $wpdb->get_results($query_posts);
                    if ($wpdb->last_error)
                        die($wpdb->last_error);
                    foreach ($results as $result)
                        $ids_posts[] = $result->ID; // gather matching post ids
                    $query_meta = [];
                    foreach($query->query_vars['s_meta_keys'] as $meta_key) // now construct a search query the search in each desired meta key
                        $query_meta[] = $wpdb->prepare("meta_key='%s' AND meta_value LIKE '%%%s%%'", $meta_key, $term);
                    $query_metas = $wpdb->prepare("SELECT * FROM {$wpdb->postmeta} WHERE ((".implode(') OR (',$query_meta)."))");
                    $ids_metas = [];
                    $results = $wpdb->get_results($query_metas);
                    if ($wpdb->last_error)
                        die($wpdb->last_error);
                    foreach ($results as $result)
                        $ids_metas[] = $result->post_id; // gather matching post ids
                    $merged = array_merge($ids_posts,$ids_metas); // merge the title, content and meta ids resulting from both queries
                    $unique = array_unique($merged); // remove duplicates
                    if (!$unique)
                        $unique = array(0); // if no result, add a "0" id otherwise all posts will be returned
                    $ids[] = $unique; // add array of matching ids into the main array
                }
            }
            if (count($ids)>1)
                $intersected = call_user_func_array('array_intersect',$ids); // if several keywords keep only ids that are found in all keywords' matching arrays
            else
                $intersected = $ids[0]; // otherwise keep the only matching ids array
            $unique = array_unique($intersected); // remove duplicates
            if (!$unique)
                $unique = array(0); // if no result, add a "0" id otherwise all posts will be returned
            unset($query->query_vars['s']); // unset normal search query
            $query->set('post__in',$unique); // add a filter by post id instead
        }
    }

    // Custom WP query query_products
    $args_query_search_products = array(
        'post_type' => array('product'), 
        'suppress_filters' => false,
        's' => $search,
        's_meta_keys' => array('product_code'),
        'nopaging' => true,
        'posts_per_page' => -1,
        'order' => 'ASC',
        'orderby' => 'title',
        
        // 'nopaging' => true,
    );

    $search_query_products = new WP_Query( $args_query_search_products );

    if ( $search_query_products->have_posts() ) {
        while ($search_query_products->have_posts()) {
            $search_query_products->the_post();

            $parent = $search_query_products->post->post_parent;
            $box = get_field('box');
            $boxImage = ( get_field('box')['image'] ) ? get_field('box')['image'] : get_field('box', $parent)['image'];
            $boxExcerpt = ( get_field('box')['excerpt'] ) ? get_field('box')['excerpt'] : get_field('box', $parent)['excerpt'];

            $desc = wp_trim_words(get_field('product_description'), $num_words = 20, $more = '...');
            $item = array(
                'parent' => get_field('box', $parent),
                'id' => get_the_ID(),
                'url' => get_the_permalink(),
                'title' => get_the_title(),
                'slug' => get_post_field( 'post_name' ),
                'box' => array(
                    'code' => get_field('product_code'),
                    'sizes' => get_field('product_sizes', false, false),
                    'image' => $boxImage,
                    'excerpt' => ( $boxExcerpt ) ? $boxExcerpt : $desc,
                ),
            );

            $products[] = $item;
        }
        wp_reset_postdata();
    }

    

    // remove_filter('posts_join','add_join_wpse_99849');
    // remove_filter('posts_search','alter_search_wpse_99849',1,2);

    $response = array(
        'products' => $products
    );

    return rest_ensure_response( $response );
}