<?php

// Check function exists.
if( function_exists('acf_add_options_sub_page') ) {

    // Add parent.
    $parent = acf_add_options_page(array(
        'page_title'  => __('Theme General Settings'),
        'menu_title'  => __('Theme Settings'),
        'redirect'    => false,
    ));

    // Add sub page.
    $child = acf_add_options_sub_page(array(
        'page_title'  => __('Header Settings'),
        'menu_title'  => __('Header'),
        'parent_slug' => $parent['menu_slug'],
    ));

    // Add sub page.
    $child = acf_add_options_sub_page(array(
        'page_title'  => __('Footer Settings'),
        'menu_title'  => __('Footer'),
        'parent_slug' => $parent['menu_slug'],
    ));

    // Add sub page.
    $child = acf_add_options_sub_page(array(
        'page_title'  => __('Learn more'),
        'menu_title'  => __('Learn more'),
        'parent_slug' => $parent['menu_slug'],
    ));
}


function my_acf_admin_head() {
    ?>
    <style type="text/css">

        .acf-fields {
            background-color: #fff;
        }

        .acf-flexible-content .layout .acf-fc-layout-handle {
            background-color: #0D95CE;
            color: #000;
            font-weight: 600;
        }

        .acf-repeater.-row > table > tbody > tr > td,
        .acf-repeater.-block > table > tbody > tr > td {
            border-top: 4px solid #0D95CE;
        }

        .acf-flexible-content .layout {
            border-bottom: 4px solid #0D95CE;
        }

        .acf-repeater .acf-row-handle {
            vertical-align: top !important;
            padding-top: 16px;
        }

        .acf-repeater .acf-row-handle span {
            font-size: 20px;
            font-weight: bold;
            color: #000;
        }

        .imageUpload img {
            width: 75px;
        }

        .acf-repeater .acf-row-handle .acf-icon.-minus {
            top: 30px;
        }

    </style>
    <?php
}

add_action('acf/input/admin_head', 'my_acf_admin_head');

function my_mce4_options($init) {

    $custom_colours = '
      "000000", "Black",
      "993300", "Burnt orange",
      "333300", "Dark olive",
      "003300", "Dark green",
      "003366", "Dark azure",
      "000080", "Navy Blue",
      "333399", "Indigo",
      "333333", "Very dark gray",
      "800000", "Maroon",
      "FF6600", "Orange",
      "808000", "Olive",
      "008000", "Green",
      "008080", "Teal",
      "0000FF", "Blue",
      "666699", "Grayish blue",
      "808080", "Gray",
      "FF0000", "Red",
      "FF9900", "Amber",
      "99CC00", "Yellow green",
      "339966", "Sea green",
      "33CCCC", "Turquoise",
      "3366FF", "Royal blue",
      "800080", "Purple",
      "999999", "Medium gray",
      "FF00FF", "Magenta",
      "FFCC00", "Gold",
      "FFFF00", "Yellow",
      "00FF00", "Lime",
      "00FFFF", "Aqua",
      "00CCFF", "Sky blue",
      "993366", "Red violet",
      "FFFFFF", "White",
      "FF99CC", "Pink",
      "FFCC99", "Peach",
      "FFFF99", "Light yellow",
      "CCFFCC", "Pale green",
      "CCFFFF", "Pale cyan",
      "99CCFF", "Light sky blue",
      "CC99FF", "Plum",
      "0D95CE", "Blue",
      "494949", "Text default"
    ';

    // build colour grid default+custom colors
    $init['textcolor_map'] = '['.$custom_colours.']';

    // change the number of rows in the grid if the number of colors changes
    // 8 swatches per row
    $init['textcolor_rows'] = 10;

    return $init;
}
add_filter('tiny_mce_before_init', 'my_mce4_options');


function my_acf_google_map_api( $api ){
    $api['key'] = 'AIzaSyDi3tbaYeF5L9cMoImfWaApEKan_Li6Nbg';
    return $api;
}
add_filter('acf/fields/google_map/api', 'my_acf_google_map_api');
