    </main>
    <?php
        $newsletter = get_field('newsletter', 'options');
        $btnLeft = get_field('button_left', 'options');
    ?>
    <footer class="main-footer">
        <div class="main-footer__container container container--fluid">
            <div class="main-footer__row row">
                <div class="main-footer__left col">
                    <div class="main-footer__newsletter">
                        <p>Subscribe to our newsletter</p>
                        <?php echo do_shortcode($newsletter); ?>
                    </div>
                    <div class="main-footer__btn">
                        <p>&nbsp;</p>
                        <?php
                            $btnVar = $btnLeft;
                            include( locate_template( 'partials/button.php', false, false ) );
                        ?>
                    </div>
                    <div class="main-footer__links">
                        <?php
                            $pages = get_field('pages', 'options');
                        ?>
                        <div class="main-footer__links__label"><?php echo $pages['heading']; ?></div>
                        <?php foreach ( $pages['links'] as $link ) : ?>
                            <?php
                                $link = $link['link'];
                            ?>
                            <a href="<?php echo $link['url']; ?>"
                               title="<?php echo $link['title']; ?>"
                               <?php echo ($link['target']) ? 'target="_blank" rel="noopener noreferrer"' : ''; ?>
                               class="main-footer__links__link"
                            ><?php echo $link['title']; ?></a>
                        <?php endforeach; ?>
                    </div>
                    <div class="main-footer__links">
                        <div class="main-footer__links__label">Sectors</div>
                        <?php
                        // Custom WP query querysector
                        $args_querysector = array(
                            'post_type' => array('sector'),
                            'posts_per_page' => -1,
                            'order' => 'DESC',
                        );

                        $querysector = new WP_Query( $args_querysector );

                        if ( $querysector->have_posts() ) : ?>
                            <?php while ( $querysector->have_posts() ) : $querysector->the_post(); ?>
                                <a href="<?php the_permalink(); ?>"
                                   title="<?php the_title(); ?>"
                                   class="main-footer__links__link"
                                ><?php the_title(); ?></a>
                            <?php endwhile; ?>
                        <?php endif; wp_reset_postdata(); ?>
                    </div>
                </div>
                <div class="main-footer__right col">
                    <div class="main-footer__right__top">
                        <?php
                            $logo = get_field('logo_footer', 'options')
                        ?>
                        <a class="main-footer__logo" href="<?php echo get_home_url('/'); ?>" title="<?php echo get_bloginfo( 'name' ); ?>">
                            <img src="<?php echo $logo['url']; ?>" width="140" height="67" alt="<?php echo get_bloginfo( 'name' ); ?>">
                        </a>
                        <?php
                            $btnVar = get_field('button_right', 'options');
                            include( locate_template( 'partials/button.php', false, false ) );
                        ?>
                    </div>
                    <?php
                        $copy = get_field('copy', 'options');
                    ?>
                    <div class="main-footer__copy">
                        <?php echo $copy; ?>
                    </div>
                    <?php
                        $logos = get_field('logos', 'options');
                    ?>
                    <div class="main-footer__logos">
                        <?php foreach ( $logos as $logo ) : ?>
                            <?php
                                $logo = $logo['logo'];
                            ?>
                            <img src="<?php echo $logo['url']; ?>" width="140" height="s7" alt="<?php echo $logo['alt']; ?>">
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    
    <?php wp_footer(); ?>
</body>
</html>